/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.google.api.client.json.gson;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.shade.com.google.api.client.json.JsonFactory;
import org.apache.pulsar.shade.com.google.api.client.json.JsonGenerator;
import org.apache.pulsar.shade.com.google.api.client.json.JsonParser;
import org.apache.pulsar.shade.com.google.api.client.json.gson.GsonGenerator;
import org.apache.pulsar.shade.com.google.api.client.json.gson.GsonParser;
import org.apache.pulsar.shade.com.google.api.client.util.Beta;
import org.apache.pulsar.shade.com.google.gson.stream.JsonReader;
import org.apache.pulsar.shade.com.google.gson.stream.JsonWriter;

public class GsonFactory
extends JsonFactory {
    @Beta
    public static GsonFactory getDefaultInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public JsonParser createJsonParser(InputStream in) {
        return this.createJsonParser(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Override
    public JsonParser createJsonParser(InputStream in, Charset charset) {
        if (charset == null) {
            return this.createJsonParser(in);
        }
        return this.createJsonParser(new InputStreamReader(in, charset));
    }

    @Override
    public JsonParser createJsonParser(String value) {
        return this.createJsonParser(new StringReader(value));
    }

    @Override
    public JsonParser createJsonParser(Reader reader) {
        return new GsonParser(this, new JsonReader(reader));
    }

    @Override
    public JsonGenerator createJsonGenerator(OutputStream out, Charset enc) {
        return this.createJsonGenerator(new OutputStreamWriter(out, enc));
    }

    @Override
    public JsonGenerator createJsonGenerator(Writer writer) {
        return new GsonGenerator(this, new JsonWriter(writer));
    }

    @Beta
    static class InstanceHolder {
        static final GsonFactory INSTANCE = new GsonFactory();

        InstanceHolder() {
        }
    }
}

