/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.NoSuchElementException;

class WormUtil {
    static final int[] RECURSIVE_MOVE_ATTEMPTS = new int[]{10, 1, 0};
    static final int END_OF_CHAIN = 127;
    static final float FIT_LOAD_FACTOR = 0.75f;

    WormUtil() {
    }

    static int addOffset(int index, int offset, int capacity) {
        assert (WormUtil.checkIndex(index, capacity));
        assert (Math.abs(offset) < 127) : "offset=" + offset;
        return index + offset & capacity - 1;
    }

    static int getOffsetBetweenIndexes(int fromIndex, int toIndex, int capacity) {
        assert (WormUtil.checkIndex(fromIndex, capacity));
        assert (WormUtil.checkIndex(toIndex, capacity));
        return toIndex - fromIndex & capacity - 1;
    }

    static int maxOffset(int capacity) {
        return Math.min(capacity, 127) - 1;
    }

    static boolean checkIndex(int index, int capacity) {
        assert (index >= 0 && index < capacity) : "index=" + index + ", capacity=" + capacity;
        return true;
    }

    static int searchFreeBucket(int fromIndex, int range, int excludedIndex, byte[] next) {
        assert (WormUtil.checkIndex(fromIndex, next.length));
        assert (range >= 0 && range <= WormUtil.maxOffset(next.length)) : "range=" + range + ", maxOffset=" + WormUtil.maxOffset(next.length);
        if (range == 0) {
            return -1;
        }
        int capacity = next.length;
        int toIndex = fromIndex + range;
        for (int index = fromIndex; index < toIndex; ++index) {
            int rolledIndex = index & capacity - 1;
            if (next[rolledIndex] != 0 || rolledIndex == excludedIndex) continue;
            return rolledIndex;
        }
        return -1;
    }

    static int findPreviousInChain(int entryIndex, byte[] next) {
        int index;
        assert (WormUtil.checkIndex(entryIndex, next.length));
        assert (next[entryIndex] < 0);
        int capacity = next.length;
        int capacityMask = capacity - 1;
        int toIndex = index - WormUtil.maxOffset(capacity);
        for (index = entryIndex - 1; index > toIndex; --index) {
            int rolledIndex = index & capacityMask;
            int absNextOffset = Math.abs(next[rolledIndex]);
            int chainedIndex = rolledIndex + absNextOffset & capacityMask;
            if (chainedIndex != entryIndex) continue;
            assert (absNextOffset != 127);
            return rolledIndex;
        }
        throw new NoSuchElementException("Previous entry not found (entryIndex=" + entryIndex + ", next[entryIndex]=" + next[entryIndex] + ")");
    }

    static int findLastOfChain(int index, int nextOffset, boolean returnPrevious, byte[] next) {
        assert (WormUtil.checkIndex(index, next.length));
        assert (nextOffset != 0 && Math.abs(nextOffset) <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + next[index];
        int capacity = next.length;
        if (nextOffset < 0) {
            nextOffset = -nextOffset;
        }
        int previousIndex = -1;
        while (nextOffset != 127) {
            previousIndex = index;
            index = WormUtil.addOffset(index, nextOffset, capacity);
            nextOffset = -next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return returnPrevious ? previousIndex : index;
    }

    static class UnionExcludedIndexes
    extends ExcludedIndexes {
        final ExcludedIndexes left;
        final ExcludedIndexes right;

        UnionExcludedIndexes(ExcludedIndexes left, ExcludedIndexes right) {
            this.left = left;
            this.right = right;
        }

        @Override
        boolean isIndexExcluded(int index) {
            return this.left.isIndexExcluded(index) || this.right.isIndexExcluded(index);
        }
    }

    static class MultipleExcludedIndexes
    extends ExcludedIndexes {
        final int[] excludedIndexes;
        final int size;

        MultipleExcludedIndexes(int index, int nextOffset, byte[] next) {
            assert (index >= 0 && index < next.length) : "index=" + index + ", next.length=" + next.length;
            assert (nextOffset > 0 && nextOffset < 127) : "nextOffset=" + nextOffset;
            int[] excludedIndexes = new int[8];
            int size = 0;
            boolean shouldSort = false;
            excludedIndexes[size++] = index;
            do {
                int nextIndex;
                if ((nextIndex = WormUtil.addOffset(index, nextOffset, next.length)) < index) {
                    shouldSort = true;
                }
                assert (nextIndex >= 0 && nextIndex < next.length) : "nextIndex=" + index + ", next.length=" + next.length;
                if (size == excludedIndexes.length) {
                    excludedIndexes = Arrays.copyOf(excludedIndexes, size * 2);
                }
                excludedIndexes[size++] = index = nextIndex;
                nextOffset = Math.abs(next[index]);
                assert (nextOffset > 0) : "nextOffset=" + nextOffset;
            } while (nextOffset != 127);
            if (shouldSort) {
                Arrays.sort(excludedIndexes, 0, size);
            }
            this.excludedIndexes = excludedIndexes;
            this.size = size;
        }

        @Override
        boolean isIndexExcluded(int index) {
            return Arrays.binarySearch(this.excludedIndexes, 0, this.size, index) >= 0;
        }
    }

    static class SingletonExcludedIndex
    extends ExcludedIndexes {
        final int excludedIndex;

        SingletonExcludedIndex(int excludedIndex) {
            this.excludedIndex = excludedIndex;
        }

        @Override
        boolean isIndexExcluded(int index) {
            return index == this.excludedIndex;
        }
    }

    static abstract class ExcludedIndexes {
        static final ExcludedIndexes NONE = new ExcludedIndexes(){

            @Override
            ExcludedIndexes union(ExcludedIndexes excludedIndexes) {
                return excludedIndexes;
            }

            @Override
            boolean isIndexExcluded(int index) {
                return false;
            }
        };

        ExcludedIndexes() {
        }

        static ExcludedIndexes fromChain(int index, byte[] next) {
            int nextOffset = Math.abs(next[index]);
            assert (nextOffset != 0) : "nextOffset=0";
            return nextOffset == 127 ? new SingletonExcludedIndex(index) : new MultipleExcludedIndexes(index, nextOffset, next);
        }

        ExcludedIndexes union(ExcludedIndexes excludedIndexes) {
            return new UnionExcludedIndexes(this, excludedIndexes);
        }

        abstract boolean isIndexExcluded(int var1);
    }

    static enum PutPolicy {
        NEW_OR_REPLACE,
        NEW_GUARANTEED,
        NEW_ONLY_IF_ABSENT;

    }
}

