/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractCharCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractObjectCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.CharContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectCharAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectCharHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectCharMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.ObjectCharComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.CharCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ObjectCharCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.CharPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.ObjectCharPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.ObjectPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.CharProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ObjectCharProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ObjectProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.sorting.QuickSort;

public class SortedIterationObjectCharHashMap<KType>
implements ObjectCharMap<KType> {
    public final ObjectCharHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectCharHashMap(ObjectCharHashMap<KType> delegate, Comparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectCharHashMap(ObjectCharHashMap<KType> delegate, ObjectCharComparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectCharComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final char[] values;
            {
                this.keys = SortedIterationObjectCharHashMap.this.delegate.keys;
                this.values = SortedIterationObjectCharHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectCharCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectCharPredicate<? super KType> predicate) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectCharProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectCharPredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public CharContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public char get(KType key) {
        return this.delegate.get(key);
    }

    @Override
    public char getOrDefault(KType key, char defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public char put(KType key, char value) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectCharAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectCharCursor<? extends KType>> iterable) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public char putOrAdd(KType key, char putValue, char incrementValue) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public char addTo(KType key, char additionValue) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public char remove(KType key) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public char indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public char indexReplace(int index, char newValue) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key, char value) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public char indexRemove(int index) {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectCharHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectCharCursor<KType>> {
        private final ObjectCharCursor<KType> cursor = new ObjectCharCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectCharCursor<KType> fetch() {
            if (this.index < SortedIterationObjectCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectCharHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectCharHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectCharCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectCharHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectCharHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final SortedIterationObjectCharHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            for (ObjectCharCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectCharHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationObjectCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectCharHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

