/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractLongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongLongAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongLongHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongLongMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.LongLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.LongComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.LongLongComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.LongCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.LongLongCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.LongLongPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.LongPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.LongLongProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.LongProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.sorting.QuickSort;

public class SortedIterationLongLongHashMap
implements LongLongMap {
    public final LongLongHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationLongLongHashMap(LongLongHashMap delegate, LongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongLongHashMap(LongLongHashMap delegate, LongLongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongLongComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final long[] values;
            {
                this.keys = SortedIterationLongLongHashMap.this.delegate.keys;
                this.values = SortedIterationLongLongHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongLongCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongLongPredicate predicate) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public <T extends LongLongProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongLongPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public LongContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public long get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public long getOrDefault(long key, long defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public long put(long key, long value) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongLongAssociativeContainer container) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongLongCursor> iterable) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public long putOrAdd(long key, long putValue, long incrementValue) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public long addTo(long key, long additionValue) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public long remove(long key) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public long indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public long indexReplace(int index, long newValue) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key, long value) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public long indexRemove(int index) {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongLongHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongLongCursor> {
        private final LongLongCursor cursor = new LongLongCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongLongCursor fetch() {
            if (this.index < SortedIterationLongLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongLongHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongLongHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongLongCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongLongHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationLongLongHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final SortedIterationLongLongHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongLongHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            for (LongLongCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongLongHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongLongHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

