/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIntCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractIterator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.AbstractObjectCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.IntCollection;
import org.apache.pulsar.shade.com.carrotsearch.hppc.IntContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.IntLookupContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.IntObjectAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.IntObjectHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.IntObjectMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.IntComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.comparators.IntObjectComparator;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.IntCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.IntObjectCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.IntObjectPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.IntPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.predicates.ObjectPredicate;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.IntObjectProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.IntProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.procedures.ObjectProcedure;
import org.apache.pulsar.shade.com.carrotsearch.hppc.sorting.QuickSort;

public class SortedIterationIntObjectHashMap<VType>
implements IntObjectMap<VType> {
    public final IntObjectHashMap<VType> delegate;
    public final int[] iterationOrder;

    public SortedIterationIntObjectHashMap(IntObjectHashMap<VType> delegate, IntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntObjectHashMap(IntObjectHashMap<VType> delegate, IntObjectComparator<VType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntObjectComparator<VType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final VType[] values;
            {
                this.keys = SortedIterationIntObjectHashMap.this.delegate.keys;
                this.values = SortedIterationIntObjectHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntObjectCursor<VType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntObjectPredicate<? super VType> predicate) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public <T extends IntObjectProcedure<? super VType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], (Object)values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntObjectPredicate<? super VType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        Object[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], (Object)values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ObjectContainer<VType> values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public VType get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public VType getOrDefault(int key, VType defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public VType put(int key, VType value) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntObjectAssociativeContainer<? extends VType> container) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntObjectCursor<? extends VType>> iterable) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public VType remove(int key) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public VType indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public VType indexReplace(int index, VType newValue) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key, VType value) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public VType indexRemove(int index) {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntObjectHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntObjectCursor<VType>> {
        private final IntObjectCursor<VType> cursor = new IntObjectCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntObjectCursor<VType> fetch() {
            if (this.index < SortedIterationIntObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntObjectHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntObjectCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntObjectHashMap<VType> owner;

        private KeysContainer() {
            this.owner = SortedIterationIntObjectHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final SortedIterationIntObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            for (IntObjectCursor c : this.owner) {
                if (!Objects.equals(value, c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(VType e) {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntObjectHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.index < SortedIterationIntObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntObjectHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntObjectHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntObjectHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntObjectHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

