/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectShortAssociativeContainer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ObjectShortHashMap;

public class ObjectShortIdentityHashMap<KType>
extends ObjectShortHashMap<KType> {
    public ObjectShortIdentityHashMap() {
        this(4);
    }

    public ObjectShortIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectShortIdentityHashMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectShortIdentityHashMap(ObjectShortAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mixPhi(System.identityHashCode(key));
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectShortIdentityHashMap<KType> from(KType[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectShortIdentityHashMap<KType> map = new ObjectShortIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

