/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreProvider;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.EtcdMetadataStoreProvider;
import org.apache.pulsar.metadata.impl.MemoryMetadataStoreProvider;
import org.apache.pulsar.metadata.impl.RocksdbMetadataStoreProvider;
import org.apache.pulsar.metadata.impl.ZkMetadataStoreProvider;
import org.apache.pulsar.shade.com.google.common.base.Splitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStoreFactoryImpl {
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreFactoryImpl.class);
    public static final String METADATASTORE_PROVIDERS_PROPERTY = "pulsar.metadatastore.providers";

    public static MetadataStore create(String metadataURL, MetadataStoreConfig metadataStoreConfig) throws MetadataStoreException {
        return MetadataStoreFactoryImpl.newInstance(metadataURL, metadataStoreConfig, false);
    }

    public static MetadataStoreExtended createExtended(String metadataURL, MetadataStoreConfig metadataStoreConfig) throws MetadataStoreException {
        MetadataStore store = MetadataStoreFactoryImpl.newInstance(metadataURL, metadataStoreConfig, true);
        if (!(store instanceof MetadataStoreExtended)) {
            throw new MetadataStoreException.InvalidImplementationException("Implementation does not comply with " + MetadataStoreExtended.class.getName());
        }
        return (MetadataStoreExtended)store;
    }

    private static MetadataStore newInstance(String metadataURL, MetadataStoreConfig metadataStoreConfig, boolean enableSessionWatcher) throws MetadataStoreException {
        MetadataStoreProvider provider = MetadataStoreFactoryImpl.findProvider(metadataURL);
        return provider.create(metadataURL, metadataStoreConfig, enableSessionWatcher);
    }

    static Map<String, MetadataStoreProvider> loadProviders() {
        HashMap<String, MetadataStoreProvider> providers = new HashMap<String, MetadataStoreProvider>();
        providers.put("memory:", new MemoryMetadataStoreProvider());
        providers.put("rocksdb:", new RocksdbMetadataStoreProvider());
        providers.put("etcd:", new EtcdMetadataStoreProvider());
        providers.put("zk:", new ZkMetadataStoreProvider());
        String factoryClasses = System.getProperty(METADATASTORE_PROVIDERS_PROPERTY, "");
        for (String className : Splitter.on(',').trimResults().omitEmptyStrings().split(factoryClasses)) {
            try {
                Class<?> clazz = Class.forName(className);
                MetadataStoreProvider provider = (MetadataStoreProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                String scheme = provider.urlScheme();
                providers.put(scheme + ":", provider);
            }
            catch (Exception e) {
                log.warn("Failed to load metadata store provider class for name '{}'", (Object)className, (Object)e);
            }
        }
        return providers;
    }

    private static MetadataStoreProvider findProvider(String metadataURL) {
        Map<String, MetadataStoreProvider> providers = MetadataStoreFactoryImpl.loadProviders();
        for (Map.Entry<String, MetadataStoreProvider> entry : providers.entrySet()) {
            if (!metadataURL.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return providers.get("zk:");
    }

    public static String removeIdentifierFromMetadataURL(String metadataURL) {
        MetadataStoreProvider provider = MetadataStoreFactoryImpl.findProvider(metadataURL);
        if (metadataURL.startsWith(provider.urlScheme() + ":")) {
            return metadataURL.substring(provider.urlScheme().length() + 1);
        }
        return metadataURL;
    }

    public static boolean isBasedOnZookeeper(String metadataURL) {
        if (!metadataURL.contains("://")) {
            return true;
        }
        return metadataURL.startsWith("zk");
    }
}

