/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarLedgerIdGenerator
implements LedgerIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(PulsarLedgerIdGenerator.class);
    private final MetadataStoreExtended store;
    private final String ledgerIdGenPath;
    private final String shortIdGenPath;
    private static final String IDGEN_NODE = "idgen-long";
    private static final String IDGEN_SHORT_NODE = "idgen";
    private static final String SHORT_ID_PREFIX = "ID-";

    public PulsarLedgerIdGenerator(MetadataStoreExtended store, String ledgersRoot) {
        this.store = store;
        this.ledgerIdGenPath = ledgersRoot + "/idgen-long";
        this.shortIdGenPath = ledgersRoot + "/idgen";
    }

    @Override
    public void generateLedgerId(BookkeeperInternalCallbacks.GenericCallback<Long> genericCallback) {
        ((CompletableFuture)((CompletableFuture)this.ledgerIdGenPathPresent().thenCompose(isIdGenPathPresent -> {
            if (isIdGenPathPresent.booleanValue()) {
                return this.generateLongLedgerId();
            }
            return this.generateShortLedgerId();
        })).thenAccept(ledgerId -> genericCallback.operationComplete(0, (Long)ledgerId))).exceptionally(ex -> {
            log.error("Error generating ledger id: {}", (Object)ex.getMessage());
            genericCallback.operationComplete(-18, -1L);
            return null;
        });
    }

    private CompletableFuture<Long> generateShortLedgerId() {
        return this.store.exists(this.shortIdGenPath).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.internalGenerateShortLedgerId();
            }
            CompletableFuture future = new CompletableFuture();
            this.store.put(this.shortIdGenPath, new byte[0], Optional.of(-1L)).whenComplete((stat, throwable) -> {
                Throwable cause = FutureUtil.unwrapCompletionException(throwable);
                if (cause == null || cause instanceof MetadataStoreException.BadVersionException) {
                    future.complete(null);
                } else {
                    future.completeExceptionally((Throwable)throwable);
                }
            });
            return future.thenCompose(__ -> this.internalGenerateShortLedgerId());
        });
    }

    private CompletableFuture<Long> internalGenerateShortLedgerId() {
        String ledgerPrefix = this.shortIdGenPath + "/ID-";
        return this.store.put(ledgerPrefix, new byte[0], Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral, CreateOption.Sequential)).thenCompose(stat -> {
            this.store.delete(this.handleTheDeletePath(stat.getPath()), Optional.empty()).exceptionally(ex -> {
                log.warn("Exception during deleting node for id generation: ", ex);
                return null;
            });
            try {
                long ledgerId = PulsarLedgerIdGenerator.getLedgerIdFromGenPath(stat.getPath(), ledgerPrefix);
                if (ledgerId < 0L || ledgerId >= Integer.MAX_VALUE) {
                    return this.store.put(this.ledgerIdGenPath, new byte[0], Optional.empty()).thenCompose(__ -> this.generateLongLedgerId());
                }
                return CompletableFuture.completedFuture(ledgerId);
            }
            catch (IOException e) {
                log.error("Could not extract ledger-id from id gen path:" + stat.getPath(), (Throwable)e);
                return FutureUtil.failedFuture(e);
            }
        });
    }

    private CompletableFuture<Long> generateLongLedgerId() {
        String hobPrefix = "HOB-";
        String ledgerPrefix = this.ledgerIdGenPath + "/HOB-";
        return this.store.getChildren(this.ledgerIdGenPath).thenCompose(highOrderDirectories -> {
            Optional<Long> largest = highOrderDirectories.stream().map(t -> {
                try {
                    return Long.parseLong(t.replace("HOB-", ""));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).filter(t -> t != null).reduce(Math::max);
            if (!largest.isPresent()) {
                return this.createHOBPathAndGenerateId(ledgerPrefix, 1);
            }
            Long highBits = largest.get();
            return this.generateLongLedgerIdLowBits(ledgerPrefix, highBits).thenApply(ledgerId -> {
                if (highOrderDirectories.size() > 3) {
                    Object[] highOrderDirs = highOrderDirectories.stream().map(t -> {
                        try {
                            return Long.parseLong(t.replace("HOB-", ""));
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }).filter(t -> t != null).sorted().toArray();
                    for (int i = 0; i < highOrderDirs.length - 3; ++i) {
                        String path = ledgerPrefix + this.formatHalfId(((Long)highOrderDirs[i]).intValue());
                        if (log.isDebugEnabled()) {
                            log.debug("DELETING HIGH ORDER DIR: {}", (Object)path);
                        }
                        this.store.delete(path, Optional.of(0L));
                    }
                }
                return ledgerId;
            });
        });
    }

    private String formatHalfId(int i) {
        return String.format("%010d", i);
    }

    private CompletableFuture<Long> createHOBPathAndGenerateId(String ledgerPrefix, int hob) {
        if (log.isDebugEnabled()) {
            log.debug("Creating HOB path: {}", (Object)(ledgerPrefix + this.formatHalfId(hob)));
        }
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.store.put(ledgerPrefix + this.formatHalfId(hob), new byte[0], Optional.empty()).whenComplete((__, ex) -> {
            if ((ex = FutureUtil.unwrapCompletionException(ex)) != null && !(ex instanceof MetadataStoreException.BadVersionException)) {
                future.completeExceptionally((Throwable)ex);
            } else {
                ((CompletableFuture)this.generateLongLedgerId().thenAccept(future::complete)).exceptionally(e -> {
                    future.completeExceptionally((Throwable)e);
                    return null;
                });
            }
        });
        return future;
    }

    private CompletableFuture<Long> generateLongLedgerIdLowBits(String ledgerPrefix, long highBits) {
        String highPath = ledgerPrefix + this.formatHalfId((int)highBits);
        return this.generateLedgerIdImpl(PulsarLedgerIdGenerator.createLedgerPrefix(highPath, null)).thenCompose(result -> {
            if (result >= 0L && result < Integer.MAX_VALUE) {
                return CompletableFuture.completedFuture(highBits << 32 | result);
            }
            Long newHighBits = highBits + 1L;
            return this.createHOBPathAndGenerateId(ledgerPrefix, newHighBits.intValue());
        });
    }

    public CompletableFuture<Long> generateLedgerIdImpl(String prefix) {
        return this.store.put(prefix, new byte[0], Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral, CreateOption.Sequential)).thenCompose(stat -> {
            this.store.delete(this.handleTheDeletePath(stat.getPath()), Optional.empty()).exceptionally(ex -> {
                log.warn("Exception during deleting node for id generation: ", ex);
                return null;
            });
            try {
                long ledgerId = PulsarLedgerIdGenerator.getLedgerIdFromGenPath(stat.getPath(), prefix);
                return CompletableFuture.completedFuture(ledgerId);
            }
            catch (IOException e) {
                log.error("Could not extract ledger-id from id gen path:" + stat.getPath(), (Throwable)e);
                return FutureUtil.failedFuture(e);
            }
        });
    }

    @Override
    public void close() throws IOException {
    }

    public CompletableFuture<Boolean> ledgerIdGenPathPresent() {
        return this.store.exists(this.ledgerIdGenPath);
    }

    private static long getLedgerIdFromGenPath(String nodeName, String ledgerPrefix) throws IOException {
        try {
            String[] parts = nodeName.split(ledgerPrefix);
            long ledgerId = Long.parseLong(parts[parts.length - 1]);
            return ledgerId;
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private static String createLedgerPrefix(String ledgersPath, String idGenZnodeName) {
        Object ledgerIdGenPath = null;
        ledgerIdGenPath = StringUtils.isBlank(idGenZnodeName) ? ledgersPath : ledgersPath + "/" + idGenZnodeName;
        return (String)ledgerIdGenPath + "/ID-";
    }

    private String handleTheDeletePath(String path) {
        if (this.store instanceof ZKMetadataStore) {
            String rootPath = ((ZKMetadataStore)this.store).getRootPath();
            if (rootPath == null) {
                return path;
            }
            return path.replaceFirst(rootPath, "");
        }
        return path;
    }
}

