/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.Resources;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.apache.pulsar.shade.io.prometheus.client.jetty.JettyStatisticsCollector;
import org.apache.pulsar.shade.javax.servlet.DispatcherType;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ConnectionLimit;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Handler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Server;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ServerConnector;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.DefaultHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.HandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.RequestLogHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.StatisticsHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.FilterHolder;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.pulsar.shade.org.eclipse.jetty.servlets.QoSFilter;
import org.apache.pulsar.shade.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.apache.pulsar.shade.org.glassfish.jersey.server.ResourceConfig;
import org.apache.pulsar.shade.org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServer {
    private static final Logger log = LoggerFactory.getLogger(WorkerServer.class);
    private final WorkerConfig workerConfig;
    private final WorkerService workerService;
    private final AuthenticationService authenticationService;
    private static final String MATCH_ALL = "/*";
    private final WebExecutorThreadPool webServerExecutor;
    private Server server;
    private ServerConnector httpConnector;
    private ServerConnector httpsConnector;
    private final FilterInitializer filterInitializer;

    public WorkerServer(WorkerService workerService, AuthenticationService authenticationService) {
        this.workerConfig = workerService.getWorkerConfig();
        this.workerService = workerService;
        this.authenticationService = authenticationService;
        this.webServerExecutor = new WebExecutorThreadPool(this.workerConfig.getNumHttpServerThreads(), "function-web", this.workerConfig.getHttpServerThreadPoolQueueSize());
        this.filterInitializer = new FilterInitializer(this.workerConfig, authenticationService);
        this.init();
    }

    public void start() throws Exception {
        this.server.start();
        log.info("Worker Server started at {}", (Object)this.server.getURI());
    }

    private void init() {
        this.server = new Server(this.webServerExecutor);
        if (this.workerConfig.getMaxHttpServerConnections() > 0) {
            this.server.addBean(new ConnectionLimit(this.workerConfig.getMaxHttpServerConnections(), this.server));
        }
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        if (this.workerConfig.getWorkerPort() != null) {
            log.info("Configuring http server on port={}", (Object)this.workerConfig.getWorkerPort());
            this.httpConnector = new ServerConnector(this.server);
            this.httpConnector.setPort(this.workerConfig.getWorkerPort());
            connectors.add(this.httpConnector);
        }
        ArrayList<AbstractHandlerContainer> handlers = new ArrayList<AbstractHandlerContainer>(4);
        handlers.add(WorkerServer.newServletContextHandler("/admin", new ResourceConfig(Resources.getApiV2Resources()), this.workerService, this.filterInitializer));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v2", new ResourceConfig(Resources.getApiV2Resources()), this.workerService, this.filterInitializer));
        handlers.add(WorkerServer.newServletContextHandler("/admin/v3", new ResourceConfig(Resources.getApiV3Resources()), this.workerService, this.filterInitializer));
        handlers.add(WorkerServer.newServletContextHandler("/", new ResourceConfig(Resources.getRootResources()), this.workerService, this.workerConfig.isAuthenticateMetricsEndpoint(), this.filterInitializer));
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog(JettyRequestLogFactory.createRequestLogger());
        handlers.add(0, new ContextHandlerCollection());
        handlers.add(requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(handlers.toArray(new Handler[handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler(handlerCollection);
        try {
            new JettyStatisticsCollector(stats).register();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        handlers.add(stats);
        this.server.setHandler(stats);
        if (this.workerConfig.getTlsEnabled()) {
            log.info("Configuring https server on port={}", (Object)this.workerConfig.getWorkerPortTls());
            try {
                SslContextFactory sslCtxFactory = this.workerConfig.isTlsEnabledWithKeyStore() ? JettySslContextFactory.createServerSslContextWithKeystore(this.workerConfig.getTlsProvider(), this.workerConfig.getTlsKeyStoreType(), this.workerConfig.getTlsKeyStore(), this.workerConfig.getTlsKeyStorePassword(), this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.getTlsTrustStoreType(), this.workerConfig.getTlsTrustStore(), this.workerConfig.getTlsTrustStorePassword(), this.workerConfig.isTlsRequireTrustedClientCertOnConnect(), this.workerConfig.getWebServiceTlsCiphers(), this.workerConfig.getWebServiceTlsProtocols(), this.workerConfig.getTlsCertRefreshCheckDurationSec()) : JettySslContextFactory.createServerSslContext(this.workerConfig.getTlsProvider(), this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.getTlsTrustCertsFilePath(), this.workerConfig.getTlsCertificateFilePath(), this.workerConfig.getTlsKeyFilePath(), this.workerConfig.isTlsRequireTrustedClientCertOnConnect(), this.workerConfig.getWebServiceTlsCiphers(), this.workerConfig.getWebServiceTlsProtocols(), this.workerConfig.getTlsCertRefreshCheckDurationSec());
                this.httpsConnector = new ServerConnector(this.server, sslCtxFactory);
                this.httpsConnector.setPort(this.workerConfig.getWorkerPortTls());
                connectors.add(this.httpsConnector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        connectors.forEach(c -> c.setAcceptQueueSize(this.workerConfig.getHttpServerAcceptQueueSize()));
        this.server.setConnectors(connectors.toArray(new ServerConnector[connectors.size()]));
    }

    static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService, FilterInitializer filterInitializer) {
        return WorkerServer.newServletContextHandler(contextPath, config, workerService, true, filterInitializer);
    }

    static ServletContextHandler newServletContextHandler(String contextPath, ResourceConfig config, WorkerService workerService, boolean requireAuthentication, FilterInitializer filterInitializer) {
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setAttribute("function-worker", workerService);
        contextHandler.setAttribute("worker", workerService);
        contextHandler.setAttribute("worker-stats", workerService);
        contextHandler.setContextPath(contextPath);
        ServletHolder apiServlet = new ServletHolder(new ServletContainer(config));
        contextHandler.addServlet(apiServlet, MATCH_ALL);
        filterInitializer.addFilters(contextHandler, requireAuthentication);
        return contextHandler;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                log.error("Failed to stop function web-server ", (Throwable)e);
            }
        }
        if (this.webServerExecutor != null && this.webServerExecutor.isRunning()) {
            try {
                this.webServerExecutor.stop();
            }
            catch (Exception e) {
                log.warn("Error stopping function web-server executor", (Throwable)e);
            }
        }
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.httpConnector != null) {
            return Optional.of(this.httpConnector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.httpsConnector != null) {
            return Optional.of(this.httpsConnector.getLocalPort());
        }
        return Optional.empty();
    }

    private static class FilterInitializer {
        private final List<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        private final FilterHolder authenticationFilterHolder;

        FilterInitializer(WorkerConfig config, AuthenticationService authenticationService) {
            if (config.getMaxConcurrentHttpRequests() > 0) {
                FilterHolder filterHolder = new FilterHolder(QoSFilter.class);
                filterHolder.setInitParameter("maxRequests", String.valueOf(config.getMaxConcurrentHttpRequests()));
                this.filterHolders.add(filterHolder);
            }
            if (config.isHttpRequestsLimitEnabled()) {
                this.filterHolders.add(new FilterHolder(new RateLimitingFilter(config.getHttpRequestsMaxPerSecond())));
            }
            if (config.isAuthenticationEnabled()) {
                this.authenticationFilterHolder = new FilterHolder(new AuthenticationFilter(authenticationService));
                this.filterHolders.add(this.authenticationFilterHolder);
            } else {
                this.authenticationFilterHolder = null;
            }
        }

        public void addFilters(ServletContextHandler context, boolean requiresAuthentication) {
            for (FilterHolder filterHolder : this.filterHolders) {
                if (!requiresAuthentication && filterHolder == this.authenticationFilterHolder) continue;
                context.addFilter(filterHolder, WorkerServer.MATCH_ALL, EnumSet.allOf(DispatcherType.class));
            }
        }
    }
}

