/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import java.util.function.Supplier;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationParameters;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.shade.javax.servlet.ServletContext;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.ws.rs.core.Context;
import org.apache.pulsar.shade.javax.ws.rs.core.UriInfo;

public class FunctionApiResource
implements Supplier<WorkerService> {
    public static final String ATTRIBUTE_FUNCTION_WORKER = "function-worker";
    public static final String ORIGINAL_PRINCIPAL_HEADER = "X-Original-Principal";
    private WorkerService workerService;
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;
    @Context
    protected UriInfo uri;

    @Override
    public synchronized WorkerService get() {
        if (this.workerService == null) {
            this.workerService = (WorkerService)this.servletContext.getAttribute(ATTRIBUTE_FUNCTION_WORKER);
        }
        return this.workerService;
    }

    public AuthenticationParameters authParams() {
        return AuthenticationParameters.builder().originalPrincipal(this.httpRequest.getHeader(ORIGINAL_PRINCIPAL_HEADER)).clientRole(this.clientAppId()).clientAuthenticationDataSource(this.clientAuthData()).build();
    }

    @Deprecated
    public String clientAppId() {
        return this.httpRequest != null ? (String)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName) : null;
    }

    @Deprecated
    public AuthenticationDataSource clientAuthData() {
        return (AuthenticationDataSource)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedDataAttributeName);
    }
}

