/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.MessageIdData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMessageImpl
implements RawMessage {
    private static final Logger log = LoggerFactory.getLogger(RawMessageImpl.class);
    private final MessageIdData id = new MessageIdData();
    private ByteBuf headersAndPayload;

    public RawMessageImpl(MessageIdData id, ByteBuf headersAndPayload) {
        this.id.copyFrom(id);
        this.headersAndPayload = headersAndPayload.retainedSlice();
    }

    @Override
    public MessageId getMessageId() {
        return new BatchMessageIdImpl(this.id.getLedgerId(), this.id.getEntryId(), this.id.getPartition(), this.id.getBatchIndex());
    }

    @Override
    public MessageIdData getMessageIdData() {
        return this.id;
    }

    @Override
    public ByteBuf getHeadersAndPayload() {
        return this.headersAndPayload.slice();
    }

    @Override
    public void close() {
        this.headersAndPayload.release();
        this.headersAndPayload = Unpooled.EMPTY_BUFFER;
    }

    @Override
    public ByteBuf serialize() {
        ByteBuf headersAndPayload = this.headersAndPayload.slice();
        int idSize = this.id.getSerializedSize();
        int headerSize = 4 + idSize + 4;
        int totalSize = headerSize + headersAndPayload.readableBytes();
        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(totalSize);
        buf.writeInt(idSize);
        this.id.writeTo(buf);
        buf.writeInt(headersAndPayload.readableBytes());
        buf.writeBytes(headersAndPayload);
        return buf;
    }

    public static RawMessage deserializeFrom(ByteBuf buffer) {
        int idSize = buffer.readInt();
        MessageIdData id = new MessageIdData();
        id.parseFrom(buffer, idSize);
        int payloadAndMetadataSize = buffer.readInt();
        ByteBuf metadataAndPayload = buffer.slice(buffer.readerIndex(), payloadAndMetadataSize);
        return new RawMessageImpl(id, metadataAndPayload);
    }
}

