/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.transaction;

import java.io.Serializable;
import java.util.Objects;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TxnID
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final long mostSigBits;
    private final long leastSigBits;
    private final transient int hashCode;
    private final transient String txnStr;

    public TxnID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
        this.hashCode = Objects.hash(mostSigBits, leastSigBits);
        this.txnStr = "(" + mostSigBits + "," + leastSigBits + ")";
    }

    public String toString() {
        return this.txnStr;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TxnID) {
            TxnID other = (TxnID)obj;
            return this.mostSigBits == other.mostSigBits && this.leastSigBits == other.leastSigBits;
        }
        return false;
    }

    public long getMostSigBits() {
        return this.mostSigBits;
    }

    public long getLeastSigBits() {
        return this.leastSigBits;
    }
}

