/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface Consumer<T>
extends Closeable {
    public String getTopic();

    public String getSubscription();

    public void unsubscribe() throws PulsarClientException;

    public CompletableFuture<Void> unsubscribeAsync();

    public Message<T> receive() throws PulsarClientException;

    public CompletableFuture<Message<T>> receiveAsync();

    public Message<T> receive(int var1, TimeUnit var2) throws PulsarClientException;

    public Messages<T> batchReceive() throws PulsarClientException;

    public CompletableFuture<Messages<T>> batchReceiveAsync();

    public void acknowledge(Message<?> var1) throws PulsarClientException;

    public void acknowledge(MessageId var1) throws PulsarClientException;

    public void acknowledge(Messages<?> var1) throws PulsarClientException;

    public void acknowledge(List<MessageId> var1) throws PulsarClientException;

    public void negativeAcknowledge(Message<?> var1);

    public void negativeAcknowledge(MessageId var1);

    public void negativeAcknowledge(Messages<?> var1);

    public void reconsumeLater(Message<?> var1, long var2, TimeUnit var4) throws PulsarClientException;

    public void reconsumeLater(Message<?> var1, Map<String, String> var2, long var3, TimeUnit var5) throws PulsarClientException;

    public void reconsumeLater(Messages<?> var1, long var2, TimeUnit var4) throws PulsarClientException;

    public void acknowledgeCumulative(Message<?> var1) throws PulsarClientException;

    public void acknowledgeCumulative(MessageId var1) throws PulsarClientException;

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId var1, Transaction var2);

    public void reconsumeLaterCumulative(Message<?> var1, long var2, TimeUnit var4) throws PulsarClientException;

    public CompletableFuture<Void> acknowledgeAsync(Message<?> var1);

    public CompletableFuture<Void> acknowledgeAsync(MessageId var1);

    public CompletableFuture<Void> acknowledgeAsync(MessageId var1, Transaction var2);

    public CompletableFuture<Void> acknowledgeAsync(Messages<?> var1);

    public CompletableFuture<Void> acknowledgeAsync(Messages<?> var1, Transaction var2);

    public CompletableFuture<Void> acknowledgeAsync(List<MessageId> var1);

    public CompletableFuture<Void> acknowledgeAsync(List<MessageId> var1, Transaction var2);

    public CompletableFuture<Void> reconsumeLaterAsync(Message<?> var1, long var2, TimeUnit var4);

    public CompletableFuture<Void> reconsumeLaterAsync(Message<?> var1, Map<String, String> var2, long var3, TimeUnit var5);

    public CompletableFuture<Void> reconsumeLaterAsync(Messages<?> var1, long var2, TimeUnit var4);

    public CompletableFuture<Void> acknowledgeCumulativeAsync(Message<?> var1);

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId var1);

    public CompletableFuture<Void> reconsumeLaterCumulativeAsync(Message<?> var1, long var2, TimeUnit var4);

    public CompletableFuture<Void> reconsumeLaterCumulativeAsync(Message<?> var1, Map<String, String> var2, long var3, TimeUnit var5);

    public ConsumerStats getStats();

    @Override
    public void close() throws PulsarClientException;

    public CompletableFuture<Void> closeAsync();

    public boolean hasReachedEndOfTopic();

    public void redeliverUnacknowledgedMessages();

    public void seek(MessageId var1) throws PulsarClientException;

    public void seek(long var1) throws PulsarClientException;

    public void seek(Function<String, Object> var1) throws PulsarClientException;

    public CompletableFuture<Void> seekAsync(Function<String, Object> var1);

    public CompletableFuture<Void> seekAsync(MessageId var1);

    public CompletableFuture<Void> seekAsync(long var1);

    public MessageId getLastMessageId() throws PulsarClientException;

    public CompletableFuture<MessageId> getLastMessageIdAsync();

    public boolean isConnected();

    public String getConsumerName();

    public void pause();

    public void resume();

    public long getLastDisconnectedTimestamp();
}

