/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.DisableDebugHttpMethodFilter;
import org.apache.pulsar.broker.web.DynamicSkipUnknownPropertyHandler;
import org.apache.pulsar.broker.web.ExceptionHandler;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.MaxRequestSizeFilter;
import org.apache.pulsar.broker.web.PreInterceptFilter;
import org.apache.pulsar.broker.web.ProcessHandlerFilter;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.ResponseHandlerFilter;
import org.apache.pulsar.broker.web.UnrecognizedPropertyExceptionMapper;
import org.apache.pulsar.broker.web.WebExecutorStats;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.jetty.JettyStatisticsCollector;
import org.apache.pulsar.shade.javax.servlet.DispatcherType;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ConnectionLimit;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Handler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Server;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ServerConnector;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.DefaultHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.HandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.RequestLogHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.ResourceHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.StatisticsHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.FilterHolder;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.pulsar.shade.org.eclipse.jetty.servlets.QoSFilter;
import org.apache.pulsar.shade.org.eclipse.jetty.util.resource.Resource;
import org.apache.pulsar.shade.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.apache.pulsar.shade.org.glassfish.jersey.server.ResourceConfig;
import org.apache.pulsar.shade.org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebService
implements AutoCloseable {
    private static final String MATCH_ALL = "/*";
    public static final String ATTRIBUTE_PULSAR_NAME = "pulsar";
    public static final String HANDLER_CACHE_CONTROL = "max-age=3600";
    private final PulsarService pulsar;
    private final Server server;
    private final List<Handler> handlers = Lists.newArrayList();
    private final WebExecutorStats executorStats;
    private final WebExecutorThreadPool webServiceExecutor;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;
    private final FilterInitializer filterInitializer;
    private JettyStatisticsCollector jettyStatisticsCollector;
    private static final DynamicSkipUnknownPropertyHandler sharedUnknownPropertyHandler = new DynamicSkipUnknownPropertyHandler();
    private static final Logger log = LoggerFactory.getLogger(WebService.class);

    public void updateHttpRequestsFailOnUnknownPropertiesEnabled(boolean httpRequestsFailOnUnknownPropertiesEnabled) {
        sharedUnknownPropertyHandler.setSkipUnknownProperty(!httpRequestsFailOnUnknownPropertiesEnabled);
    }

    public WebService(PulsarService pulsar) throws PulsarServerException {
        this.pulsar = pulsar;
        ServiceConfiguration config = pulsar.getConfiguration();
        this.webServiceExecutor = new WebExecutorThreadPool(config.getNumHttpServerThreads(), "pulsar-web", config.getHttpServerThreadPoolQueueSize());
        this.executorStats = WebExecutorStats.getStats(this.webServiceExecutor);
        this.server = new Server(this.webServiceExecutor);
        if (config.getMaxHttpServerConnections() > 0) {
            this.server.addBean(new ConnectionLimit(config.getMaxHttpServerConnections(), this.server));
        }
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        Optional<Integer> port = config.getWebServicePort();
        if (port.isPresent()) {
            this.httpConnector = new ServerConnector(this.server);
            this.httpConnector.setPort(port.get());
            this.httpConnector.setHost(pulsar.getBindAddress());
            connectors.add(this.httpConnector);
        } else {
            this.httpConnector = null;
        }
        Optional<Integer> tlsPort = config.getWebServicePortTls();
        if (tlsPort.isPresent()) {
            try {
                SslContextFactory sslCtxFactory = config.isTlsEnabledWithKeyStore() ? JettySslContextFactory.createServerSslContextWithKeystore(config.getWebServiceTlsProvider(), config.getTlsKeyStoreType(), config.getTlsKeyStore(), config.getTlsKeyStorePassword(), config.isTlsAllowInsecureConnection(), config.getTlsTrustStoreType(), config.getTlsTrustStore(), config.getTlsTrustStorePassword(), config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols(), config.getTlsCertRefreshCheckDurationSec()) : JettySslContextFactory.createServerSslContext(config.getWebServiceTlsProvider(), config.isTlsAllowInsecureConnection(), config.getTlsTrustCertsFilePath(), config.getTlsCertificateFilePath(), config.getTlsKeyFilePath(), config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols(), config.getTlsCertRefreshCheckDurationSec());
                this.httpsConnector = new ServerConnector(this.server, sslCtxFactory);
                this.httpsConnector.setPort(tlsPort.get());
                this.httpsConnector.setHost(pulsar.getBindAddress());
                connectors.add(this.httpsConnector);
            }
            catch (Exception e) {
                throw new PulsarServerException(e);
            }
        } else {
            this.httpsConnector = null;
        }
        connectors.forEach(c -> c.setAcceptQueueSize(config.getHttpServerAcceptQueueSize()));
        this.server.setConnectors(connectors.toArray(new ServerConnector[connectors.size()]));
        this.filterInitializer = new FilterInitializer(pulsar);
        sharedUnknownPropertyHandler.setSkipUnknownProperty(!config.isHttpRequestsFailOnUnknownPropertiesEnabled());
    }

    public void addRestResources(String basePath, boolean requiresAuthentication, Map<String, Object> attributeMap, boolean useSharedJsonMapperProvider, String ... javaPackages) {
        ResourceConfig config = new ResourceConfig();
        for (String javaPackage : javaPackages) {
            config.packages(false, javaPackage);
        }
        this.addResourceServlet(basePath, requiresAuthentication, attributeMap, config, useSharedJsonMapperProvider);
    }

    public void addRestResource(String basePath, boolean requiresAuthentication, Map<String, Object> attributeMap, boolean useSharedJsonMapperProvider, Class<?> ... resourceClasses) {
        ResourceConfig config = new ResourceConfig();
        for (Class<?> resourceClass : resourceClasses) {
            config.register((Class)resourceClass);
        }
        this.addResourceServlet(basePath, requiresAuthentication, attributeMap, config, useSharedJsonMapperProvider);
    }

    private void addResourceServlet(String basePath, boolean requiresAuthentication, Map<String, Object> attributeMap, ResourceConfig config, boolean useSharedJsonMapperProvider) {
        if (useSharedJsonMapperProvider) {
            JsonMapperProvider jsonMapperProvider = new JsonMapperProvider(sharedUnknownPropertyHandler);
            config.register(jsonMapperProvider);
            config.register((Class)UnrecognizedPropertyExceptionMapper.class);
        } else {
            config.register((Class)JsonMapperProvider.class);
        }
        config.register((Class)MultiPartFeature.class);
        ServletHolder servletHolder = new ServletHolder(new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        this.addServlet(basePath, servletHolder, requiresAuthentication, attributeMap);
    }

    public void addServlet(String path, ServletHolder servletHolder, boolean requiresAuthentication, Map<String, Object> attributeMap) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(path);
        context.addServlet(servletHolder, MATCH_ALL);
        if (attributeMap != null) {
            attributeMap.forEach((key, value) -> context.setAttribute((String)key, value));
        }
        this.filterInitializer.addFilters(context, requiresAuthentication);
        this.handlers.add(context);
    }

    public void addStaticResources(String basePath, String resourcePath) {
        ContextHandler capHandler = new ContextHandler();
        capHandler.setContextPath(basePath);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setBaseResource(Resource.newClassPathResource(resourcePath));
        resHandler.setEtags(true);
        resHandler.setCacheControl(HANDLER_CACHE_CONTROL);
        capHandler.setHandler(resHandler);
        this.handlers.add(capHandler);
    }

    public void start() throws PulsarServerException {
        try {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog(JettyRequestLogFactory.createRequestLogger());
            this.handlers.add(0, new ContextHandlerCollection());
            this.handlers.add(requestLogHandler);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler(handlerCollection);
            try {
                this.jettyStatisticsCollector = new JettyStatisticsCollector(stats);
                this.jettyStatisticsCollector.register();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.handlers.add(stats);
            this.server.setHandler(stats);
            this.server.start();
            if (this.httpConnector != null) {
                log.info("HTTP Service started at http://{}:{}", (Object)this.httpConnector.getHost(), (Object)this.httpConnector.getLocalPort());
                this.pulsar.getConfiguration().setWebServicePort(Optional.of(this.httpConnector.getLocalPort()));
            } else {
                log.info("HTTP Service disabled");
            }
            if (this.httpsConnector != null) {
                log.info("HTTPS Service started at https://{}:{}", (Object)this.httpsConnector.getHost(), (Object)this.httpsConnector.getLocalPort());
                this.pulsar.getConfiguration().setWebServicePortTls(Optional.of(this.httpsConnector.getLocalPort()));
            } else {
                log.info("HTTPS Service disabled");
            }
        }
        catch (Exception e) {
            throw new PulsarServerException(e);
        }
    }

    @Override
    public void close() throws PulsarServerException {
        try {
            this.server.stop();
            if (this.jettyStatisticsCollector != null) {
                try {
                    CollectorRegistry.defaultRegistry.unregister(this.jettyStatisticsCollector);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.jettyStatisticsCollector = null;
            }
            this.webServiceExecutor.join();
            this.executorStats.close();
            log.info("Web service closed");
        }
        catch (Exception e) {
            throw new PulsarServerException(e);
        }
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.httpConnector != null) {
            return Optional.of(this.httpConnector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.httpsConnector != null) {
            return Optional.of(this.httpsConnector.getLocalPort());
        }
        return Optional.empty();
    }

    public static DynamicSkipUnknownPropertyHandler getSharedUnknownPropertyHandler() {
        return sharedUnknownPropertyHandler;
    }

    private static class FilterInitializer {
        private final List<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        private final FilterHolder authenticationFilterHolder;

        FilterInitializer(PulsarService pulsarService) {
            ServiceConfiguration config = pulsarService.getConfiguration();
            if (config.getMaxConcurrentHttpRequests() > 0) {
                FilterHolder filterHolder = new FilterHolder(QoSFilter.class);
                filterHolder.setInitParameter("maxRequests", String.valueOf(config.getMaxConcurrentHttpRequests()));
                this.filterHolders.add(filterHolder);
            }
            if (config.isHttpRequestsLimitEnabled()) {
                this.filterHolders.add(new FilterHolder(new RateLimitingFilter(config.getHttpRequestsMaxPerSecond())));
            }
            if (!config.getBrokerInterceptors().isEmpty() || !config.isDisableBrokerInterceptors()) {
                ExceptionHandler handler = new ExceptionHandler();
                this.filterHolders.add(new FilterHolder(new PreInterceptFilter(pulsarService.getBrokerInterceptor(), handler)));
                this.filterHolders.add(new FilterHolder(new ProcessHandlerFilter(pulsarService)));
            }
            if (config.isAuthenticationEnabled()) {
                this.authenticationFilterHolder = new FilterHolder(new AuthenticationFilter(pulsarService.getBrokerService().getAuthenticationService()));
                this.filterHolders.add(this.authenticationFilterHolder);
            } else {
                this.authenticationFilterHolder = null;
            }
            if (config.isDisableHttpDebugMethods()) {
                this.filterHolders.add(new FilterHolder(new DisableDebugHttpMethodFilter(config)));
            }
            if (config.getHttpMaxRequestSize() > 0L) {
                this.filterHolders.add(new FilterHolder(new MaxRequestSizeFilter(config.getHttpMaxRequestSize())));
            }
            this.filterHolders.add(new FilterHolder(new ResponseHandlerFilter(pulsarService)));
        }

        public void addFilters(ServletContextHandler context, boolean requiresAuthentication) {
            for (FilterHolder filterHolder : this.filterHolders) {
                if (!requiresAuthentication && filterHolder == this.authenticationFilterHolder) continue;
                context.addFilter(filterHolder, WebService.MATCH_ALL, EnumSet.allOf(DispatcherType.class));
            }
        }
    }
}

