/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.shade.javax.servlet.Filter;
import org.apache.pulsar.shade.javax.servlet.FilterChain;
import org.apache.pulsar.shade.javax.servlet.FilterConfig;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private final AuthenticationService authenticationService;
    public static final String AuthenticatedRoleAttributeName = AuthenticationFilter.class.getName() + "-role";
    public static final String AuthenticatedDataAttributeName = AuthenticationFilter.class.getName() + "-data";
    public static final String PULSAR_AUTH_METHOD_NAME = "X-Pulsar-Auth-Method-Name";

    public AuthenticationFilter(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    private boolean isSaslRequest(HttpServletRequest request) {
        if (request.getHeader("SASL-Type") == null || request.getHeader("SASL-Type").isEmpty()) {
            return false;
        }
        return request.getHeader("SASL-Type").equalsIgnoreCase("Kerberos");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (!this.isSaslRequest(httpRequest)) {
                String role;
                String authMethodName = httpRequest.getHeader(PULSAR_AUTH_METHOD_NAME);
                if (authMethodName != null && this.authenticationService.getAuthenticationProvider(authMethodName) != null) {
                    AuthenticationState authenticationState = this.authenticationService.getAuthenticationProvider(authMethodName).newHttpAuthState(httpRequest);
                    request.setAttribute(AuthenticatedDataAttributeName, authenticationState.getAuthDataSource());
                    role = this.authenticationService.authenticateHttpRequest((HttpServletRequest)request, authenticationState.getAuthDataSource());
                } else {
                    request.setAttribute(AuthenticatedDataAttributeName, new AuthenticationDataHttps((HttpServletRequest)request));
                    role = this.authenticationService.authenticateHttpRequest((HttpServletRequest)request);
                }
                request.setAttribute(AuthenticatedRoleAttributeName, role);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[{}] Authenticated HTTP request with role {}", (Object)request.getRemoteAddr(), (Object)role);
                }
                chain.doFilter(request, response);
                return;
            }
            boolean doFilter = this.authenticationService.getAuthenticationProvider("sasl").authenticateHttpRequest(httpRequest, httpResponse);
            if (doFilter) {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(401, "Authentication required");
            if (e instanceof AuthenticationException) {
                LOG.warn("[{}] Failed to authenticate HTTP request: {}", (Object)request.getRemoteAddr(), (Object)e.getMessage());
            } else {
                LOG.error("[{}] Error performing authentication for HTTP", (Object)request.getRemoteAddr(), (Object)e);
            }
            return;
        }
    }

    @Override
    public void init(FilterConfig arg) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}

