/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.broker.transaction.pendingack.proto.LightProtoCodec;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadataEntry;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class BatchedPendingAckMetadataEntry {
    private List<PendingAckMetadataEntry> pendingAckLogs = null;
    private int _pendingAckLogsCount = 0;
    private static final int _PENDING_ACK_LOGS_FIELD_NUMBER = 1;
    private static final int _PENDING_ACK_LOGS_TAG = 10;
    private static final int _PENDING_ACK_LOGS_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 0;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public int getPendingAckLogsCount() {
        return this._pendingAckLogsCount;
    }

    public PendingAckMetadataEntry getPendingAckLogAt(int idx) {
        if (idx < 0 || idx >= this._pendingAckLogsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._pendingAckLogsCount + ") for field 'pending_ack_logs'");
        }
        return this.pendingAckLogs.get(idx);
    }

    public List<PendingAckMetadataEntry> getPendingAckLogsList() {
        if (this._pendingAckLogsCount == 0) {
            return Collections.emptyList();
        }
        return this.pendingAckLogs.subList(0, this._pendingAckLogsCount);
    }

    public PendingAckMetadataEntry addPendingAckLog() {
        if (this.pendingAckLogs == null) {
            this.pendingAckLogs = new ArrayList<PendingAckMetadataEntry>();
        }
        if (this.pendingAckLogs.size() == this._pendingAckLogsCount) {
            this.pendingAckLogs.add(new PendingAckMetadataEntry());
        }
        this._cachedSize = -1;
        return this.pendingAckLogs.get(this._pendingAckLogsCount++);
    }

    public BatchedPendingAckMetadataEntry addAllPendingAckLogs(Iterable<PendingAckMetadataEntry> pendingAckLogs) {
        for (PendingAckMetadataEntry _o : pendingAckLogs) {
            this.addPendingAckLog().copyFrom(_o);
        }
        return this;
    }

    public BatchedPendingAckMetadataEntry clearPendingAckLogs() {
        for (int i = 0; i < this._pendingAckLogsCount; ++i) {
            this.pendingAckLogs.get(i).clear();
        }
        this._pendingAckLogsCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        int _writeIdx = _b.writerIndex();
        for (int i = 0; i < this._pendingAckLogsCount; ++i) {
            PendingAckMetadataEntry _item = this.pendingAckLogs.get(i);
            LightProtoCodec.writeVarInt(_b, 10);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        for (int i = 0; i < this._pendingAckLogsCount; ++i) {
            PendingAckMetadataEntry _item = this.pendingAckLogs.get(i);
            _size += _PENDING_ACK_LOGS_TAG_SIZE;
            int MsgsizePendingAckLogs = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizePendingAckLogs) + MsgsizePendingAckLogs;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block3: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    int _pendingAckLogsSize = LightProtoCodec.readVarInt(_buffer);
                    this.addPendingAckLog().parseFrom(_buffer, _pendingAckLogsSize);
                    continue block3;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this._parsedBuffer = _buffer;
    }

    public BatchedPendingAckMetadataEntry clear() {
        for (int i = 0; i < this._pendingAckLogsCount; ++i) {
            this.pendingAckLogs.get(i).clear();
        }
        this._pendingAckLogsCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public BatchedPendingAckMetadataEntry copyFrom(BatchedPendingAckMetadataEntry _other) {
        this._cachedSize = -1;
        for (int i = 0; i < _other.getPendingAckLogsCount(); ++i) {
            this.addPendingAckLog().copyFrom(_other.getPendingAckLogAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

