/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.TransactionBufferSnapshotService;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.SystemTopicClientBase;
import org.apache.pulsar.broker.transaction.buffer.matadata.TransactionBufferSnapshot;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBufferSystemTopicClient
extends SystemTopicClientBase<TransactionBufferSnapshot> {
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferSystemTopicClient.class);
    private TransactionBufferSnapshotService transactionBufferSnapshotService;

    public TransactionBufferSystemTopicClient(PulsarClient client, TopicName topicName, TransactionBufferSnapshotService transactionBufferSnapshotService) {
        super(client, topicName);
        this.transactionBufferSnapshotService = transactionBufferSnapshotService;
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Writer<TransactionBufferSnapshot>> newWriterAsyncInternal() {
        return this.client.newProducer(Schema.AVRO(TransactionBufferSnapshot.class)).topic(this.topicName.toString()).createAsync().thenCompose(producer -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new transactionBufferSnapshot writer is created", (Object)this.topicName);
            }
            return CompletableFuture.completedFuture(new TransactionBufferSnapshotWriter((Producer<TransactionBufferSnapshot>)producer, this));
        });
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Reader<TransactionBufferSnapshot>> newReaderAsyncInternal() {
        return this.client.newReader(Schema.AVRO(TransactionBufferSnapshot.class)).topic(this.topicName.toString()).startMessageId(MessageId.earliest).readCompacted(true).createAsync().thenCompose(reader -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new transactionBufferSnapshot buffer reader is created", (Object)this.topicName);
            }
            return CompletableFuture.completedFuture(new TransactionBufferSnapshotReader((Reader<TransactionBufferSnapshot>)reader, this));
        });
    }

    protected void removeWriter(TransactionBufferSnapshotWriter writer) {
        this.writers.remove(writer);
        this.transactionBufferSnapshotService.removeClient(this.topicName, this);
    }

    protected void removeReader(TransactionBufferSnapshotReader reader) {
        this.readers.remove(reader);
        this.transactionBufferSnapshotService.removeClient(this.topicName, this);
    }

    private static class TransactionBufferSnapshotReader
    implements SystemTopicClient.Reader<TransactionBufferSnapshot> {
        private final Reader<TransactionBufferSnapshot> reader;
        private final TransactionBufferSystemTopicClient transactionBufferSystemTopicClient;

        private TransactionBufferSnapshotReader(Reader<TransactionBufferSnapshot> reader, TransactionBufferSystemTopicClient transactionBufferSystemTopicClient) {
            this.reader = reader;
            this.transactionBufferSystemTopicClient = transactionBufferSystemTopicClient;
        }

        @Override
        public Message<TransactionBufferSnapshot> readNext() throws PulsarClientException {
            return this.reader.readNext();
        }

        @Override
        public CompletableFuture<Message<TransactionBufferSnapshot>> readNextAsync() {
            return this.reader.readNextAsync();
        }

        @Override
        public boolean hasMoreEvents() throws PulsarClientException {
            return this.reader.hasMessageAvailable();
        }

        @Override
        public CompletableFuture<Boolean> hasMoreEventsAsync() {
            return this.reader.hasMessageAvailableAsync();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.transactionBufferSystemTopicClient.removeReader(this);
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
            this.reader.closeAsync().whenComplete((v, e) -> {
                this.transactionBufferSystemTopicClient.removeReader(this);
                if (e != null) {
                    completableFuture.completeExceptionally((Throwable)e);
                    return;
                }
                completableFuture.complete(null);
            });
            return completableFuture;
        }

        @Override
        public SystemTopicClient<TransactionBufferSnapshot> getSystemTopic() {
            return this.transactionBufferSystemTopicClient;
        }
    }

    private static class TransactionBufferSnapshotWriter
    implements SystemTopicClient.Writer<TransactionBufferSnapshot> {
        private final Producer<TransactionBufferSnapshot> producer;
        private final TransactionBufferSystemTopicClient transactionBufferSystemTopicClient;

        private TransactionBufferSnapshotWriter(Producer<TransactionBufferSnapshot> producer, TransactionBufferSystemTopicClient transactionBufferSystemTopicClient) {
            this.producer = producer;
            this.transactionBufferSystemTopicClient = transactionBufferSystemTopicClient;
        }

        @Override
        public MessageId write(TransactionBufferSnapshot transactionBufferSnapshot) throws PulsarClientException {
            return this.producer.newMessage().key(transactionBufferSnapshot.getTopicName()).value(transactionBufferSnapshot).send();
        }

        @Override
        public CompletableFuture<MessageId> writeAsync(TransactionBufferSnapshot transactionBufferSnapshot) {
            return this.producer.newMessage().key(transactionBufferSnapshot.getTopicName()).value(transactionBufferSnapshot).sendAsync();
        }

        @Override
        public MessageId delete(TransactionBufferSnapshot transactionBufferSnapshot) throws PulsarClientException {
            return this.producer.newMessage().key(transactionBufferSnapshot.getTopicName()).value(null).send();
        }

        @Override
        public CompletableFuture<MessageId> deleteAsync(TransactionBufferSnapshot transactionBufferSnapshot) {
            return this.producer.newMessage().key(transactionBufferSnapshot.getTopicName()).value(null).sendAsync();
        }

        @Override
        public void close() throws IOException {
            this.producer.close();
            this.transactionBufferSystemTopicClient.removeWriter(this);
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
            this.producer.closeAsync().whenComplete((v, e) -> {
                this.transactionBufferSystemTopicClient.removeWriter(this);
                if (e != null) {
                    completableFuture.completeExceptionally((Throwable)e);
                    return;
                }
                completableFuture.complete(null);
            });
            return completableFuture;
        }

        @Override
        public SystemTopicClient<TransactionBufferSnapshot> getSystemTopicClient() {
            return this.transactionBufferSystemTopicClient;
        }
    }
}

