/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SimpleTextOutputStream;

public class PrometheusMetricsGeneratorUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String cluster, OutputStream out, List<PrometheusRawMetricsProvider> metricsProviders) throws IOException {
        ByteBuf buf = PulsarByteBufAllocator.DEFAULT.heapBuffer();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            PrometheusMetricsGeneratorUtils.generateSystemMetrics(stream, cluster);
            if (metricsProviders != null) {
                for (PrometheusRawMetricsProvider metricsProvider : metricsProviders) {
                    metricsProvider.generate(stream);
                }
            }
            out.write(buf.array(), buf.arrayOffset(), buf.readableBytes());
        }
        finally {
            buf.release();
        }
    }

    public static void generateSystemMetrics(SimpleTextOutputStream stream, String cluster) {
        Enumeration<Collector.MetricFamilySamples> metricFamilySamples = CollectorRegistry.defaultRegistry.metricFamilySamples();
        while (metricFamilySamples.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamily = metricFamilySamples.nextElement();
            stream.write("# TYPE ").write(metricFamily.name).write(PrometheusMetricsGeneratorUtils.getTypeNameSuffix(metricFamily.type)).write(' ').write(PrometheusMetricsGeneratorUtils.getTypeStr(metricFamily.type)).write('\n');
            for (int i = 0; i < metricFamily.samples.size(); ++i) {
                Collector.MetricFamilySamples.Sample sample = metricFamily.samples.get(i);
                stream.write(sample.name);
                stream.write("{");
                if (!sample.labelNames.contains("cluster")) {
                    stream.write("cluster=\"").write(cluster).write('\"');
                    if (!CollectionUtils.isEmpty(sample.labelNames)) {
                        stream.write(",");
                    }
                }
                for (int j = 0; j < sample.labelNames.size(); ++j) {
                    String labelValue = sample.labelValues.get(j);
                    if (labelValue != null) {
                        labelValue = labelValue.replace("\"", "\\\"");
                    }
                    if (j > 0) {
                        stream.write(",");
                    }
                    stream.write(sample.labelNames.get(j));
                    stream.write("=\"");
                    stream.write(labelValue);
                    stream.write('\"');
                }
                stream.write("} ");
                stream.write(Collector.doubleToGoString(sample.value));
                stream.write('\n');
            }
        }
    }

    static String getTypeNameSuffix(Collector.Type type) {
        if (type.equals((Object)Collector.Type.INFO)) {
            return "_info";
        }
        return "";
    }

    static String getTypeStr(Collector.Type type) {
        switch (type) {
            case COUNTER: {
                return "counter";
            }
            case GAUGE: 
            case INFO: {
                return "gauge";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "unknown";
    }
}

