/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.Counter;
import org.apache.pulsar.shade.io.prometheus.client.Summary;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;

class SchemaRegistryStats
implements AutoCloseable,
Runnable {
    private static final String NAMESPACE = "namespace";
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999, 1.0};
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private final Counter getOpsFailedCounter;
    private final Counter putOpsFailedCounter;
    private final Counter deleteOpsFailedCounter;
    private final Counter compatibleCounter;
    private final Counter incompatibleCounter;
    private final Summary deleteOpsLatency;
    private final Summary getOpsLatency;
    private final Summary putOpsLatency;
    private final Map<String, Long> namespaceAccess = new ConcurrentHashMap<String, Long>();
    private ScheduledFuture<?> future;
    private static volatile SchemaRegistryStats instance;

    static synchronized SchemaRegistryStats getInstance(ScheduledExecutorService scheduler) {
        if (null == instance) {
            instance = new SchemaRegistryStats(scheduler);
        }
        return instance;
    }

    private SchemaRegistryStats(ScheduledExecutorService scheduler) {
        this.deleteOpsFailedCounter = (Counter)((Counter.Builder)Counter.build("pulsar_schema_del_ops_failed_total", "-").labelNames(NAMESPACE)).create().register();
        this.getOpsFailedCounter = (Counter)((Counter.Builder)Counter.build("pulsar_schema_get_ops_failed_total", "-").labelNames(NAMESPACE)).create().register();
        this.putOpsFailedCounter = (Counter)((Counter.Builder)Counter.build("pulsar_schema_put_ops_failed_total", "-").labelNames(NAMESPACE)).create().register();
        this.compatibleCounter = (Counter)((Counter.Builder)Counter.build("pulsar_schema_compatible_total", "-").labelNames(NAMESPACE)).create().register();
        this.incompatibleCounter = (Counter)((Counter.Builder)Counter.build("pulsar_schema_incompatible_total", "-").labelNames(NAMESPACE)).create().register();
        this.deleteOpsLatency = this.buildSummary("pulsar_schema_del_ops_latency", "-");
        this.getOpsLatency = this.buildSummary("pulsar_schema_get_ops_latency", "-");
        this.putOpsLatency = this.buildSummary("pulsar_schema_put_ops_latency", "-");
        if (null != scheduler) {
            this.future = scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        }
    }

    private Summary buildSummary(String name, String help) {
        Summary.Builder builder = (Summary.Builder)Summary.build(name, help).labelNames(NAMESPACE);
        for (double quantile : QUANTILES) {
            builder.quantile(quantile, 0.01);
        }
        return (Summary)builder.create().register();
    }

    void recordDelFailed(String schemaId) {
        ((Counter.Child)this.deleteOpsFailedCounter.labels(this.getNamespace(schemaId))).inc();
    }

    void recordGetFailed(String schemaId) {
        ((Counter.Child)this.getOpsFailedCounter.labels(this.getNamespace(schemaId))).inc();
    }

    void recordPutFailed(String schemaId) {
        ((Counter.Child)this.putOpsFailedCounter.labels(this.getNamespace(schemaId))).inc();
    }

    void recordDelLatency(String schemaId, long millis) {
        ((Summary.Child)this.deleteOpsLatency.labels(this.getNamespace(schemaId))).observe(millis);
    }

    void recordGetLatency(String schemaId, long millis) {
        ((Summary.Child)this.getOpsLatency.labels(this.getNamespace(schemaId))).observe(millis);
    }

    void recordPutLatency(String schemaId, long millis) {
        ((Summary.Child)this.putOpsLatency.labels(this.getNamespace(schemaId))).observe(millis);
    }

    void recordSchemaIncompatible(String schemaId) {
        ((Counter.Child)this.incompatibleCounter.labels(this.getNamespace(schemaId))).inc();
    }

    void recordSchemaCompatible(String schemaId) {
        ((Counter.Child)this.compatibleCounter.labels(this.getNamespace(schemaId))).inc();
    }

    private String getNamespace(String schemaId) {
        String namespace;
        try {
            namespace = TopicName.get(schemaId).getNamespace();
        }
        catch (IllegalArgumentException t) {
            namespace = "unknown";
        }
        this.namespaceAccess.put(namespace, System.currentTimeMillis());
        return namespace;
    }

    private void removeChild(String namespace) {
        this.getOpsFailedCounter.remove(namespace);
        this.putOpsFailedCounter.remove(namespace);
        this.deleteOpsFailedCounter.remove(namespace);
        this.compatibleCounter.remove(namespace);
        this.incompatibleCounter.remove(namespace);
        this.deleteOpsLatency.remove(namespace);
        this.getOpsLatency.remove(namespace);
        this.putOpsLatency.remove(namespace);
    }

    @Override
    public void close() throws Exception {
        if (CLOSED.compareAndSet(false, true)) {
            CollectorRegistry.defaultRegistry.unregister(this.deleteOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister(this.getOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister(this.putOpsFailedCounter);
            CollectorRegistry.defaultRegistry.unregister(this.compatibleCounter);
            CollectorRegistry.defaultRegistry.unregister(this.incompatibleCounter);
            CollectorRegistry.defaultRegistry.unregister(this.deleteOpsLatency);
            CollectorRegistry.defaultRegistry.unregister(this.getOpsLatency);
            CollectorRegistry.defaultRegistry.unregister(this.putOpsLatency);
            if (null != this.future) {
                this.future.cancel(false);
            }
        }
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        long interval = TimeUnit.MINUTES.toMillis(5L);
        this.namespaceAccess.entrySet().removeIf(entry -> {
            String namespace = (String)entry.getKey();
            long accessTime = (Long)entry.getValue();
            if (now - accessTime > interval) {
                this.removeChild(namespace);
                return true;
            }
            return false;
        });
    }
}

