/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.resource.usage;

import org.apache.pulsar.broker.service.resource.usage.LightProtoCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class StorageUsage {
    private long totalBytes;
    private static final int _TOTAL_BYTES_FIELD_NUMBER = 1;
    private static final int _TOTAL_BYTES_TAG = 8;
    private static final int _TOTAL_BYTES_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _TOTAL_BYTES_MASK = 1;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasTotalBytes() {
        return (this._bitField0 & 1) != 0;
    }

    public long getTotalBytes() {
        if (!this.hasTotalBytes()) {
            throw new IllegalStateException("Field 'totalBytes' is not set");
        }
        return this.totalBytes;
    }

    public StorageUsage setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public StorageUsage clearTotalBytes() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.totalBytes);
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _TOTAL_BYTES_TAG_SIZE;
        this._cachedSize = _size += LightProtoCodec.computeVarInt64Size(this.totalBytes);
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block3: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.totalBytes = LightProtoCodec.readVarInt64(_buffer);
                    continue block3;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public StorageUsage clear() {
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public StorageUsage copyFrom(StorageUsage _other) {
        this._cachedSize = -1;
        if (_other.hasTotalBytes()) {
            this.setTotalBytes(_other.totalBytes);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

