/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.BoundType;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;

public final class ServiceUnitUtils {
    private static final String OWNER_INFO_ROOT = "/namespace";

    static String path(NamespaceBundle suname) {
        return "/namespace/" + suname.toString();
    }

    public static NamespaceBundle suBundleFromPath(String path, NamespaceBundleFactory factory) {
        String[] parts = path.split("/");
        Preconditions.checkArgument(parts.length > 2);
        Preconditions.checkArgument(parts[1].equals("namespace"));
        Preconditions.checkArgument(parts.length > 4);
        if (parts.length > 5) {
            Range<Long> range = ServiceUnitUtils.getHashRange(parts[5]);
            return factory.getBundle(NamespaceName.get(parts[2], parts[3], parts[4]), range);
        }
        Range<Long> range = ServiceUnitUtils.getHashRange(parts[4]);
        return factory.getBundle(NamespaceName.get(parts[2], parts[3]), range);
    }

    private static Range<Long> getHashRange(String rangePathPart) {
        String[] endPoints = rangePathPart.split("_");
        Preconditions.checkArgument(endPoints.length == 2, "Malformed bundle hash range path part:" + rangePathPart);
        Long startLong = Long.decode(endPoints[0]);
        Long endLong = Long.decode(endPoints[1]);
        BoundType endType = endPoints[1].equals("0xffffffff") ? BoundType.CLOSED : BoundType.OPEN;
        return Range.range(startLong, BoundType.CLOSED, endLong, endType);
    }
}

