/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup.v1;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.lookup.TopicLookupBase;
import org.apache.pulsar.broker.web.NoSwaggerDocumentation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.DefaultValue;
import org.apache.pulsar.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.HeaderParam;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.QueryParam;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.container.Suspended;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v2/destination/")
@NoSwaggerDocumentation
public class TopicLookup
extends TopicLookupBase {
    private static final Logger log = LoggerFactory.getLogger(TopicLookup.class);
    static final String LISTENERNAME_HEADER = "X-Pulsar-ListenerName";

    @GET
    @Path(value="{topic-domain}/{property}/{cluster}/{namespace}/{topic}")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic")})
    public void lookupTopicAsync(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic-domain") String topicDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="listenerName") String listenerName, @HeaderParam(value="X-Pulsar-ListenerName") String listenerNameHeader) {
        TopicName topicName = this.getTopicName(topicDomain, property, cluster, namespace, encodedTopic);
        if (StringUtils.isEmpty(listenerName) && StringUtils.isNotEmpty(listenerNameHeader)) {
            listenerName = listenerNameHeader;
        }
        ((CompletableFuture)this.internalLookupTopicAsync(topicName, authoritative, listenerName).thenAccept(lookupData -> asyncResponse.resume(lookupData))).exceptionally(ex -> {
            if (log.isDebugEnabled()) {
                log.debug("Failed to check exist for topic {} when lookup", (Object)topicName, ex);
            }
            TopicLookup.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="{topic-domain}/{property}/{cluster}/{namespace}/{topic}/bundle")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Invalid topic domain type")})
    public String getNamespaceBundle(@PathParam(value="topic-domain") String topicDomain, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        TopicName topicName = this.getTopicName(topicDomain, property, cluster, namespace, encodedTopic);
        return this.internalGetNamespaceBundle(topicName);
    }
}

