/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.admin.impl.ResourceQuotasBase;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiParam;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.container.Suspended;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceQuota;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resource-quotas")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resource-quotas", description="Quota admin APIs", tags={"resource-quotas"})
public class ResourceQuotas
extends ResourceQuotasBase {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuotas.class);

    @GET
    @ApiOperation(value="Get the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void getDefaultResourceQuota(@Suspended AsyncResponse response) {
        ((CompletableFuture)this.getDefaultResourceQuotaAsync().thenAccept(response::resume)).exceptionally(ex -> {
            log.error("[{}] Failed to get default resource quota", (Object)this.clientAppId());
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @POST
    @ApiOperation(value="Set the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setDefaultResourceQuota(@Suspended AsyncResponse response, @ApiParam(value="Default resource quota") ResourceQuota quota) {
        ((CompletableFuture)this.setDefaultResourceQuotaAsync(quota).thenAccept(__ -> response.resume(Response.noContent().build()))).exceptionally(ex -> {
            log.error("[{}] Failed to set default resource quota", (Object)this.clientAppId());
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Get resource quota of a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getNamespaceBundleResourceQuota(@Suspended AsyncResponse response, @ApiParam(value="Tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="Namespace name within the specified tenant") @PathParam(value="namespace") String namespace, @ApiParam(value="Namespace bundle range") @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(tenant, namespace);
        ((CompletableFuture)this.internalGetNamespaceBundleResourceQuota(bundleRange).thenAccept(response::resume)).exceptionally(ex -> {
            log.error("[{}] Failed to get namespace resource quota for bundle {}", new Object[]{this.clientAppId(), bundleRange, ex});
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Set resource quota on a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setNamespaceBundleResourceQuota(@Suspended AsyncResponse response, @ApiParam(value="Tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="Namespace name within the specified tenant") @PathParam(value="namespace") String namespace, @ApiParam(value="Namespace bundle range") @PathParam(value="bundle") String bundleRange, @ApiParam(value="Resource quota for the specified namespace") ResourceQuota quota) {
        this.validateNamespaceName(tenant, namespace);
        ((CompletableFuture)this.internalSetNamespaceBundleResourceQuota(bundleRange, quota).thenAccept(__ -> {
            log.info("[{}] Successfully set namespace bundle resource quota {}", (Object)this.clientAppId(), (Object)bundleRange);
            response.resume(Response.noContent().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to set namespace resource quota for bundle {}", new Object[]{this.clientAppId(), bundleRange, ex});
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Remove resource quota for a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceBundleResourceQuota(@Suspended AsyncResponse response, @ApiParam(value="Tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="Namespace name within the specified tenant") @PathParam(value="namespace") String namespace, @ApiParam(value="Namespace bundle range") @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(tenant, namespace);
        ((CompletableFuture)this.internalRemoveNamespaceBundleResourceQuota(bundleRange).thenAccept(__ -> {
            log.info("[{}] Successfully remove namespace bundle resource quota {}", (Object)this.clientAppId(), (Object)bundleRange);
            response.resume(Response.noContent().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to remove namespace bundle resource quota {}", new Object[]{this.clientAppId(), bundleRange, ex});
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }
}

