/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Charsets;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.LongSchemaVersionResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.PostSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasResourceBase
extends AdminResource {
    private final Clock clock;
    private static final Logger log = LoggerFactory.getLogger(SchemasResourceBase.class);

    public SchemasResourceBase() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    public SchemasResourceBase(Clock clock) {
        this.clock = clock;
    }

    protected static long getLongSchemaVersion(SchemaVersion schemaVersion) {
        if (schemaVersion instanceof LongSchemaVersion) {
            return ((LongSchemaVersion)schemaVersion).getVersion();
        }
        return -1L;
    }

    private String getSchemaId() {
        if (this.topicName.isPartitioned()) {
            return TopicName.get(this.topicName.getPartitionedTopicName()).getSchemaName();
        }
        return this.topicName.getSchemaName();
    }

    public void getSchema(boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().getSchema(schemaId).handle((schema, error) -> {
            SchemasResourceBase.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchemaAsync(boolean authoritative) {
        return ((CompletableFuture)this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenApply(__ -> this.getSchemaId())).thenCompose(schemaId -> this.pulsar().getSchemaRegistryService().getSchema((String)schemaId));
    }

    public void getSchema(boolean authoritative, String version, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        ByteBuffer bbVersion = ByteBuffer.allocate(8);
        bbVersion.putLong(Long.parseLong(version));
        SchemaVersion v = this.pulsar().getSchemaRegistryService().versionFromBytes(bbVersion.array());
        this.pulsar().getSchemaRegistryService().getSchema(schemaId, v).handle((schema, error) -> {
            SchemasResourceBase.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchemaAsync(boolean authoritative, String version) {
        return ((CompletableFuture)this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenApply(__ -> this.getSchemaId())).thenCompose(schemaId -> {
            ByteBuffer bbVersion = ByteBuffer.allocate(8);
            bbVersion.putLong(Long.parseLong(version));
            SchemaRegistryService schemaRegistryService = this.pulsar().getSchemaRegistryService();
            SchemaVersion schemaVersion = schemaRegistryService.versionFromBytes(bbVersion.array());
            return schemaRegistryService.getSchema((String)schemaId, schemaVersion);
        });
    }

    public void getAllSchemas(boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().trimDeletedSchemaAndGetList(schemaId).handle((schema, error) -> {
            SchemasResourceBase.handleGetAllSchemasResponse(response, schema, error);
            return null;
        });
    }

    public CompletableFuture<List<SchemaRegistry.SchemaAndMetadata>> getAllSchemasAsync(boolean authoritative) {
        return this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenCompose(__ -> {
            String schemaId = this.getSchemaId();
            return this.pulsar().getSchemaRegistryService().trimDeletedSchemaAndGetList(schemaId);
        });
    }

    public void deleteSchema(boolean authoritative, AsyncResponse response, boolean force) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        this.pulsar().getSchemaRegistryService().deleteSchema(schemaId, StringUtils.defaultIfEmpty(this.clientAppId(), ""), force).handle((version, error) -> {
            if (Objects.isNull(error)) {
                response.resume(Response.ok().entity(DeleteSchemaResponse.builder().version(SchemasResourceBase.getLongSchemaVersion(version)).build()).build());
            } else {
                log.error("[{}] Failed to delete schema for topic {}", new Object[]{this.clientAppId(), this.topicName, error});
                response.resume(new RestException((Throwable)error));
            }
            return null;
        });
    }

    public CompletableFuture<SchemaVersion> deleteSchemaAsync(boolean authoritative, boolean force) {
        return this.validateDestinationAndAdminOperationAsync(authoritative).thenCompose(__ -> {
            String schemaId = this.getSchemaId();
            return this.pulsar().getSchemaRegistryService().deleteSchema(schemaId, StringUtils.defaultIfEmpty(this.clientAppId(), ""), force);
        });
    }

    public void postSchema(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        ((CompletableFuture)this.getSchemaCompatibilityStrategyAsync().thenAccept(schemaCompatibilityStrategy -> {
            byte[] data;
            if (SchemaType.KEY_VALUE.name().equals(payload.getType())) {
                try {
                    data = DefaultImplementation.getDefaultImplementation().convertKeyValueDataStringToSchemaInfoSchema(payload.getSchema().getBytes(Charsets.UTF_8));
                }
                catch (IOException conversionError) {
                    log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, conversionError});
                    response.resume(new RestException(conversionError));
                    return;
                }
            } else {
                data = payload.getSchema().getBytes(Charsets.UTF_8);
            }
            ((CompletableFuture)this.pulsar().getSchemaRegistryService().putSchemaIfAbsent(this.getSchemaId(), SchemaData.builder().data(data).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)((Object)schemaCompatibilityStrategy)).thenAccept(version -> response.resume(Response.accepted().entity(PostSchemaResponse.builder().version((SchemaVersion)version).build()).build()))).exceptionally(error -> {
                Throwable throwable = FutureUtil.unwrapCompletionException(error);
                if (throwable instanceof IncompatibleSchemaException) {
                    response.resume(Response.status(Response.Status.CONFLICT.getStatusCode(), throwable.getMessage()).build());
                } else if (throwable instanceof InvalidSchemaDataException) {
                    response.resume(Response.status(422, throwable.getMessage()).build());
                } else {
                    log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, throwable});
                    response.resume(new RestException(throwable));
                }
                return null;
            });
        })).exceptionally(error -> {
            Throwable throwable = FutureUtil.unwrapCompletionException(error);
            if (throwable instanceof RestException) {
                response.resume(Response.status(((RestException)throwable).getResponse().getStatus(), throwable.getMessage()).build());
            } else {
                log.error("[{}] Failed to post schema for topic {}", new Object[]{this.clientAppId(), this.topicName, throwable});
                response.resume(new RestException(throwable));
            }
            return null;
        });
    }

    public CompletableFuture<SchemaVersion> postSchemaAsync(PostSchemaPayload payload, boolean authoritative) {
        return ((CompletableFuture)this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.PRODUCE).thenCompose(__ -> this.getSchemaCompatibilityStrategyAsyncWithoutAuth())).thenCompose(schemaCompatibilityStrategy -> {
            byte[] data;
            if (SchemaType.KEY_VALUE.name().equals(payload.getType())) {
                try {
                    data = DefaultImplementation.getDefaultImplementation().convertKeyValueDataStringToSchemaInfoSchema(payload.getSchema().getBytes(Charsets.UTF_8));
                }
                catch (IOException conversionError) {
                    throw new RestException(conversionError);
                }
            } else {
                data = payload.getSchema().getBytes(Charsets.UTF_8);
            }
            return this.pulsar().getSchemaRegistryService().putSchemaIfAbsent(this.getSchemaId(), SchemaData.builder().data(data).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)((Object)schemaCompatibilityStrategy));
        });
    }

    public void testCompatibility(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        ((CompletableFuture)this.getSchemaCompatibilityStrategyAsync().thenCompose(schemaCompatibilityStrategy -> this.pulsar().getSchemaRegistryService().isCompatible(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)((Object)schemaCompatibilityStrategy)).thenAccept(isCompatible -> response.resume(Response.accepted().entity(IsCompatibilityResponse.builder().isCompatibility((boolean)isCompatible).schemaCompatibilityStrategy(schemaCompatibilityStrategy.name()).build()).build())))).exceptionally(error -> {
            response.resume(new RestException(FutureUtil.unwrapCompletionException(error)));
            return null;
        });
    }

    public CompletableFuture<Pair<Boolean, SchemaCompatibilityStrategy>> testCompatibilityAsync(PostSchemaPayload payload, boolean authoritative) {
        return ((CompletableFuture)this.validateDestinationAndAdminOperationAsync(authoritative).thenCompose(__ -> this.getSchemaCompatibilityStrategyAsync())).thenCompose(strategy -> {
            String schemaId = this.getSchemaId();
            return this.pulsar().getSchemaRegistryService().isCompatible(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)((Object)strategy)).thenApply(v -> Pair.of(v, strategy));
        });
    }

    public void getVersionBySchema(PostSchemaPayload payload, boolean authoritative, AsyncResponse response) {
        this.validateDestinationAndAdminOperation(authoritative);
        String schemaId = this.getSchemaId();
        ((CompletableFuture)this.pulsar().getSchemaRegistryService().findSchemaVersion(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build()).thenAccept(version -> response.resume(Response.accepted().entity(LongSchemaVersionResponse.builder().version((Long)version).build()).build()))).exceptionally(error -> {
            Throwable throwable = FutureUtil.unwrapCompletionException(error);
            log.error("[{}] Failed to get version by schema for topic {}", new Object[]{this.clientAppId(), this.topicName, throwable});
            response.resume(new RestException(throwable));
            return null;
        });
    }

    public CompletableFuture<Long> getVersionBySchemaAsync(PostSchemaPayload payload, boolean authoritative) {
        return this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenCompose(__ -> {
            String schemaId = this.getSchemaId();
            return this.pulsar().getSchemaRegistryService().findSchemaVersion(schemaId, SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf(payload.getType())).user(StringUtils.defaultIfEmpty(this.clientAppId(), "")).props(payload.getProperties()).build());
        });
    }

    @Override
    protected String domain() {
        return "persistent";
    }

    private static GetSchemaResponse convertSchemaAndMetadataToGetSchemaResponse(SchemaRegistry.SchemaAndMetadata schemaAndMetadata) {
        try {
            String schemaData = schemaAndMetadata.schema.getType() == SchemaType.KEY_VALUE ? DefaultImplementation.getDefaultImplementation().convertKeyValueSchemaInfoDataToString(DefaultImplementation.getDefaultImplementation().decodeKeyValueSchemaInfo(schemaAndMetadata.schema.toSchemaInfo())) : new String(schemaAndMetadata.schema.getData(), StandardCharsets.UTF_8);
            return GetSchemaResponse.builder().version(SchemasResourceBase.getLongSchemaVersion(schemaAndMetadata.version)).type(schemaAndMetadata.schema.getType()).timestamp(schemaAndMetadata.schema.getTimestamp()).data(schemaData).properties(schemaAndMetadata.schema.getProps()).build();
        }
        catch (IOException conversionError) {
            throw new RuntimeException(conversionError);
        }
    }

    protected static void handleGetSchemaResponse(AsyncResponse response, SchemaRegistry.SchemaAndMetadata schema, Throwable error) {
        if (Objects.isNull(error)) {
            if (Objects.isNull(schema)) {
                response.resume(Response.status(Response.Status.NOT_FOUND.getStatusCode(), "Schema not found").build());
            } else if (schema.schema.isDeleted()) {
                response.resume(Response.status(Response.Status.NOT_FOUND.getStatusCode(), "Schema is deleted").build());
            } else {
                response.resume(Response.ok().encoding("application/json").entity(SchemasResourceBase.convertSchemaAndMetadataToGetSchemaResponse(schema)).build());
            }
        } else {
            log.error("Failed to get schema", error);
            response.resume(new RestException(error));
        }
    }

    protected GetSchemaResponse convertToSchemaResponse(SchemaRegistry.SchemaAndMetadata schema) {
        if (Objects.isNull(schema)) {
            throw new RestException(Response.Status.NOT_FOUND.getStatusCode(), "Schema not found");
        }
        if (schema.schema.isDeleted()) {
            throw new RestException(Response.Status.NOT_FOUND.getStatusCode(), "Schema is deleted");
        }
        return SchemasResourceBase.convertSchemaAndMetadataToGetSchemaResponse(schema);
    }

    protected GetAllVersionsSchemaResponse convertToAllVersionsSchemaResponse(List<SchemaRegistry.SchemaAndMetadata> schemas) {
        if (Objects.isNull(schemas)) {
            throw new RestException(Response.Status.NOT_FOUND.getStatusCode(), "Schemas not found");
        }
        return GetAllVersionsSchemaResponse.builder().getSchemaResponses(schemas.stream().map(SchemasResourceBase::convertSchemaAndMetadataToGetSchemaResponse).collect(Collectors.toList())).build();
    }

    private static void handleGetAllSchemasResponse(AsyncResponse response, List<SchemaRegistry.SchemaAndMetadata> schemas, Throwable error) {
        if (Objects.isNull(error)) {
            if (Objects.isNull(schemas)) {
                response.resume(Response.status(Response.Status.NOT_FOUND.getStatusCode(), "Schemas not found").build());
            } else {
                response.resume(Response.ok().encoding("application/json").entity(GetAllVersionsSchemaResponse.builder().getSchemaResponses(schemas.stream().map(SchemasResourceBase::convertSchemaAndMetadataToGetSchemaResponse).collect(Collectors.toList())).build()).build());
            }
        } else {
            log.error("Failed to get all schemas", error);
            response.resume(new RestException(error));
        }
    }

    private void validateDestinationAndAdminOperation(boolean authoritative) {
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
            this.validateTopicOwnership(this.topicName, authoritative);
        }
        catch (RestException e) {
            if (e.getResponse().getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new RestException(Response.Status.UNAUTHORIZED, e.getMessage());
            }
            throw e;
        }
    }

    private CompletableFuture<Void> validateDestinationAndAdminOperationAsync(boolean authoritative) {
        return this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateAdminAccessForTenantAsync(this.topicName.getTenant()));
    }

    private CompletableFuture<Void> validateOwnershipAndOperationAsync(boolean authoritative, TopicOperation operation) {
        return this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, operation));
    }

    protected boolean shouldPrintErrorLog(Throwable ex) {
        return !SchemasResourceBase.isRedirectException(ex) && !SchemasResourceBase.isNotFoundException(ex);
    }
}

