/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.pulsar.broker.admin.impl.NamespacesBase;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceQuota;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceQuotasBase
extends NamespacesBase {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuotasBase.class);

    public ResourceQuota getDefaultResourceQuota() {
        return (ResourceQuota)this.sync(() -> this.getDefaultResourceQuotaAsync());
    }

    public CompletableFuture<ResourceQuota> getDefaultResourceQuotaAsync() {
        return this.validateSuperUserAccessAsync().thenCompose(__ -> this.pulsar().getBrokerService().getBundlesQuotas().getDefaultResourceQuota());
    }

    public CompletableFuture<Void> setDefaultResourceQuotaAsync(ResourceQuota quota) {
        return ((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.pulsar().getBrokerService().getBundlesQuotas().setDefaultResourceQuota(quota));
    }

    protected CompletableFuture<ResourceQuota> internalGetNamespaceBundleResourceQuota(String bundleRange) {
        return this.getNamespaceBundleRangeAsync(bundleRange, false).thenCompose(nsBundle -> this.pulsar().getBrokerService().getBundlesQuotas().getResourceQuota((NamespaceBundle)nsBundle));
    }

    protected CompletableFuture<Void> internalSetNamespaceBundleResourceQuota(String bundleRange, ResourceQuota quota) {
        return this.getNamespaceBundleRangeAsync(bundleRange, true).thenCompose(nsBundle -> this.pulsar().getBrokerService().getBundlesQuotas().setResourceQuota((NamespaceBundle)nsBundle, quota));
    }

    protected CompletableFuture<Void> internalRemoveNamespaceBundleResourceQuota(String bundleRange) {
        return this.getNamespaceBundleRangeAsync(bundleRange, true).thenCompose(nsBundle -> this.pulsar().getBrokerService().getBundlesQuotas().resetResourceQuota((NamespaceBundle)nsBundle));
    }

    private CompletableFuture<NamespaceBundle> getNamespaceBundleRangeAsync(String bundleRange, boolean checkReadOnly) {
        CompletionStage ret = this.validateSuperUserAccessAsync().thenCompose(__ -> {
            if (checkReadOnly) {
                return this.validatePoliciesReadOnlyAccessAsync();
            }
            return CompletableFuture.completedFuture(null);
        });
        if (!this.namespaceName.isGlobal()) {
            ret = ((CompletableFuture)((CompletableFuture)ret).thenCompose(__ -> this.validateClusterOwnershipAsync(this.namespaceName.getCluster()))).thenCompose(__ -> this.validateClusterForTenantAsync(this.namespaceName.getTenant(), this.namespaceName.getCluster()));
        }
        return ((CompletableFuture)((CompletableFuture)ret).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> this.validateNamespaceBundleRange(this.namespaceName, policies.bundles, bundleRange));
    }
}

