/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.bookie.rackawareness.BookieRackAffinityMapping;
import org.apache.pulsar.bookie.rackawareness.IsolatedBookieEnsemblePlacementPolicy;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.bookkeeper.PulsarMetadataClientDriver;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.RegionAwareEnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperClientFactoryImpl
implements BookKeeperClientFactory {
    private static final Logger log = LoggerFactory.getLogger(BookKeeperClientFactoryImpl.class);

    @Override
    public BookKeeper create(ServiceConfiguration conf, MetadataStoreExtended store, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties) throws IOException {
        return this.create(conf, store, eventLoopGroup, ensemblePlacementPolicyClass, properties, NullStatsLogger.INSTANCE);
    }

    @Override
    public BookKeeper create(ServiceConfiguration conf, MetadataStoreExtended store, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties, StatsLogger statsLogger) throws IOException {
        MetadataDrivers.registerClientDriver("metadata-store", PulsarMetadataClientDriver.class);
        ClientConfiguration bkConf = this.createBkClientConfiguration(store, conf);
        if (properties != null) {
            properties.forEach((key, value) -> bkConf.setProperty((String)key, value));
        }
        if (ensemblePlacementPolicyClass.isPresent()) {
            this.setEnsemblePlacementPolicy(bkConf, conf, store, ensemblePlacementPolicyClass.get());
        } else {
            BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(bkConf, conf, store);
        }
        try {
            return this.getBookKeeperBuilder(conf, eventLoopGroup, statsLogger, bkConf).build();
        }
        catch (InterruptedException | BKException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    BookKeeper.Builder getBookKeeperBuilder(ServiceConfiguration conf, EventLoopGroup eventLoopGroup, StatsLogger statsLogger, ClientConfiguration bkConf) {
        BookKeeper.Builder builder = BookKeeper.forConfig(bkConf).allocator(PulsarByteBufAllocator.DEFAULT).statsLogger(statsLogger);
        if (!conf.isBookkeeperClientSeparatedIoThreadsEnabled()) {
            builder.eventLoopGroup(eventLoopGroup);
        }
        return builder;
    }

    @VisibleForTesting
    ClientConfiguration createBkClientConfiguration(MetadataStoreExtended store, ServiceConfiguration conf) {
        ClientConfiguration bkConf = new ClientConfiguration();
        if (conf.getBookkeeperClientAuthenticationPlugin() != null && conf.getBookkeeperClientAuthenticationPlugin().trim().length() > 0) {
            bkConf.setClientAuthProviderFactoryClass(conf.getBookkeeperClientAuthenticationPlugin());
            bkConf.setProperty(conf.getBookkeeperClientAuthenticationParametersName(), conf.getBookkeeperClientAuthenticationParameters());
        }
        if (conf.isBookkeeperTLSClientAuthentication()) {
            bkConf.setTLSClientAuthentication(true);
            bkConf.setTLSCertificatePath(conf.getBookkeeperTLSCertificateFilePath());
            bkConf.setTLSKeyStore(conf.getBookkeeperTLSKeyFilePath());
            bkConf.setTLSKeyStoreType(conf.getBookkeeperTLSKeyFileType());
            bkConf.setTLSKeyStorePasswordPath(conf.getBookkeeperTLSKeyStorePasswordPath());
            bkConf.setTLSProviderFactoryClass(conf.getBookkeeperTLSProviderFactoryClass());
            bkConf.setTLSTrustStore(conf.getBookkeeperTLSTrustCertsFilePath());
            bkConf.setTLSTrustStoreType(conf.getBookkeeperTLSTrustCertTypes());
            bkConf.setTLSTrustStorePasswordPath(conf.getBookkeeperTLSTrustStorePasswordPath());
            bkConf.setTLSCertFilesRefreshDurationSeconds(conf.getBookkeeperTlsCertFilesRefreshDurationSeconds());
        }
        bkConf.setBusyWaitEnabled(conf.isEnableBusyWait());
        bkConf.setNumWorkerThreads(conf.getBookkeeperClientNumWorkerThreads());
        bkConf.setThrottleValue(conf.getBookkeeperClientThrottleValue());
        bkConf.setAddEntryTimeout((int)conf.getBookkeeperClientTimeoutInSeconds());
        bkConf.setReadEntryTimeout((int)conf.getBookkeeperClientTimeoutInSeconds());
        bkConf.setSpeculativeReadTimeout(conf.getBookkeeperClientSpeculativeReadTimeoutInMillis());
        bkConf.setNumChannelsPerBookie(conf.getBookkeeperNumberOfChannelsPerBookie());
        bkConf.setUseV2WireProtocol(conf.isBookkeeperUseV2WireProtocol());
        bkConf.setEnableDigestTypeAutodetection(true);
        bkConf.setStickyReadsEnabled(conf.isBookkeeperEnableStickyReads());
        bkConf.setNettyMaxFrameSizeBytes(conf.getMaxMessageSize() + 10240);
        bkConf.setDiskWeightBasedPlacementEnabled(conf.isBookkeeperDiskWeightBasedPlacementEnabled());
        bkConf.setMetadataServiceUri(conf.getBookkeeperMetadataStoreUrl());
        if (!conf.isBookkeeperMetadataStoreSeparated()) {
            bkConf.setProperty("metadata-store-instance", store);
        }
        if (conf.isBookkeeperClientHealthCheckEnabled()) {
            bkConf.enableBookieHealthCheck();
            bkConf.setBookieHealthCheckInterval((int)conf.getBookkeeperClientHealthCheckIntervalSeconds(), TimeUnit.SECONDS);
            bkConf.setBookieErrorThresholdPerInterval(conf.getBookkeeperClientHealthCheckErrorThresholdPerInterval());
            bkConf.setBookieQuarantineTime((int)conf.getBookkeeperClientHealthCheckQuarantineTimeInSeconds(), TimeUnit.SECONDS);
            bkConf.setBookieQuarantineRatio(conf.getBookkeeperClientQuarantineRatio());
        }
        bkConf.setReorderReadSequenceEnabled(conf.isBookkeeperClientReorderReadSequenceEnabled());
        bkConf.setExplictLacInterval(conf.getBookkeeperExplicitLacIntervalInMills());
        bkConf.setGetBookieInfoIntervalSeconds(conf.getBookkeeperClientGetBookieInfoIntervalSeconds(), TimeUnit.SECONDS);
        bkConf.setGetBookieInfoRetryIntervalSeconds(conf.getBookkeeperClientGetBookieInfoRetryIntervalSeconds(), TimeUnit.SECONDS);
        bkConf.setNumIOThreads(conf.getBookkeeperClientNumIoThreads());
        PropertiesUtils.filterAndMapProperties(conf.getProperties(), "bookkeeper_").forEach((key, value) -> {
            log.info("Applying BookKeeper client configuration setting {}={}", key, value);
            bkConf.setProperty((String)key, value);
        });
        return bkConf;
    }

    static void setDefaultEnsemblePlacementPolicy(ClientConfiguration bkConf, ServiceConfiguration conf, MetadataStore store) {
        bkConf.setProperty("METADATA_STORE_INSTANCE", store);
        if (conf.isBookkeeperClientRackawarePolicyEnabled() || conf.isBookkeeperClientRegionawarePolicyEnabled()) {
            if (conf.isBookkeeperClientRegionawarePolicyEnabled()) {
                bkConf.setEnsemblePlacementPolicy(RegionAwareEnsemblePlacementPolicy.class);
                bkConf.setProperty("reppEnableValidation", conf.getProperties().getProperty("reppEnableValidation", "true"));
                bkConf.setProperty("reppRegionsToWrite", conf.getProperties().getProperty("reppRegionsToWrite", null));
                bkConf.setProperty("reppMinimumRegionsForDurability", conf.getProperties().getProperty("reppMinimumRegionsForDurability", "2"));
                bkConf.setProperty("reppEnableDurabilityEnforcementInReplace", conf.getProperties().getProperty("reppEnableDurabilityEnforcementInReplace", "true"));
            } else {
                bkConf.setEnsemblePlacementPolicy(RackawareEnsemblePlacementPolicy.class);
            }
            bkConf.setMinNumRacksPerWriteQuorum(conf.getBookkeeperClientMinNumRacksPerWriteQuorum());
            bkConf.setEnforceMinNumRacksPerWriteQuorum(conf.isBookkeeperClientEnforceMinNumRacksPerWriteQuorum());
            bkConf.setProperty("reppDnsResolverClass", conf.getProperties().getProperty("reppDnsResolverClass", BookieRackAffinityMapping.class.getName()));
            bkConf.setProperty("networkTopologyScriptFileName", conf.getProperties().getProperty("networkTopologyScriptFileName", ""));
        }
        if (conf.getBookkeeperClientIsolationGroups() != null && !conf.getBookkeeperClientIsolationGroups().isEmpty()) {
            bkConf.setEnsemblePlacementPolicy(IsolatedBookieEnsemblePlacementPolicy.class);
            bkConf.setProperty("isolationBookieGroups", conf.getBookkeeperClientIsolationGroups());
            bkConf.setProperty("secondaryIsolationBookieGroups", conf.getBookkeeperClientSecondaryIsolationGroups());
        }
    }

    private void setEnsemblePlacementPolicy(ClientConfiguration bkConf, ServiceConfiguration conf, MetadataStore store, Class<? extends EnsemblePlacementPolicy> policyClass) {
        bkConf.setEnsemblePlacementPolicy(policyClass);
        bkConf.setProperty("METADATA_STORE_INSTANCE", store);
        if (conf.isBookkeeperClientRackawarePolicyEnabled() || conf.isBookkeeperClientRegionawarePolicyEnabled()) {
            bkConf.setProperty("reppDnsResolverClass", conf.getProperties().getProperty("reppDnsResolverClass", BookieRackAffinityMapping.class.getName()));
            bkConf.setProperty("networkTopologyScriptFileName", conf.getProperties().getProperty("networkTopologyScriptFileName", ""));
        }
    }

    @Override
    public void close() {
    }
}

