/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.beust.jcommander.Parameters;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;
import org.apache.pulsar.shade.org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.FieldContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Generate documentation automatically.")
public abstract class BaseGenerateDocumentation {
    private static final Logger log = LoggerFactory.getLogger(BaseGenerateDocumentation.class);
    JCommander jcommander;
    @Parameter(names={"-c", "--class-names"}, description="List of class names, generate documentation based on the annotations in the Class")
    private List<String> classNames = new ArrayList<String>();
    @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
    boolean help;
    protected Predicate<Field> isRequired = field -> {
        FieldContext fieldContext = field.getAnnotation(FieldContext.class);
        return fieldContext.required();
    };
    protected Predicate<Field> isOptional = field -> {
        FieldContext fieldContext = field.getAnnotation(FieldContext.class);
        return !fieldContext.deprecated() && !fieldContext.required();
    };
    protected Predicate<Field> isDeprecated = field -> {
        FieldContext fieldContext = field.getAnnotation(FieldContext.class);
        return fieldContext.deprecated();
    };
    protected String prefix = ":::note\n\nThis page is automatically generated from code files.\nIf you find something inaccurate, feel free to update `";
    protected String suffix = "`. Do NOT edit this markdown file manually. Manual changes will be overwritten by automatic generation.\n\n:::\n";

    public BaseGenerateDocumentation() {
        this.jcommander = new JCommander();
        this.jcommander.setProgramName("pulsar-generateDocumentation");
        this.jcommander.addObject(this);
    }

    public boolean run(String[] args) throws Exception {
        if (args.length == 0) {
            this.jcommander.usage();
            return false;
        }
        if (this.help) {
            this.jcommander.usage();
            return true;
        }
        try {
            this.jcommander.parse(Arrays.copyOfRange(args, 0, args.length));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.jcommander.usage();
            return false;
        }
        if (!CollectionUtils.isEmpty(this.classNames)) {
            for (String className : this.classNames) {
                System.out.println(this.generateDocumentByClassName(className));
            }
        }
        return true;
    }

    protected abstract String generateDocumentByClassName(String var1) throws Exception;

    protected void writeDocListByFieldContext(List<Field> fieldList, StringBuilder sb, Object obj) throws Exception {
        for (Field field : fieldList) {
            FieldContext fieldContext = field.getAnnotation(FieldContext.class);
            field.setAccessible(true);
            sb.append("### ").append(field.getName()).append("\n");
            sb.append(fieldContext.doc().replace(">", "\\>")).append("\n\n");
            sb.append("**Default**: `").append(field.get(obj)).append("`\n\n");
            sb.append("**Dynamic**: `").append(fieldContext.dynamic()).append("`\n\n");
            sb.append("**Category**: ").append(fieldContext.category()).append("\n\n");
        }
    }

    protected String generateDocByFieldContext(String className, String type, StringBuilder sb) throws Exception {
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        fieldList.removeIf(f -> f.getAnnotation(FieldContext.class) == null);
        fieldList.sort(new CategoryComparator());
        List<Field> requiredFields = fieldList.stream().filter(this.isRequired).toList();
        List<Field> optionalFields = fieldList.stream().filter(this.isOptional).toList();
        List<Field> deprecatedFields = fieldList.stream().filter(this.isDeprecated).toList();
        sb.append("# ").append(type).append("\n");
        sb.append(this.prefix).append(className).append(this.suffix);
        sb.append("## Required\n");
        this.writeDocListByFieldContext(requiredFields, sb, obj);
        sb.append("## Optional\n");
        this.writeDocListByFieldContext(optionalFields, sb, obj);
        sb.append("## Deprecated\n");
        this.writeDocListByFieldContext(deprecatedFields, sb, obj);
        return sb.toString();
    }

    protected String generateDocByApiModelProperty(String className, String type, StringBuilder sb) throws Exception {
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        fieldList.sort(Comparator.comparing(Field::getName));
        sb.append("# ").append(type).append("\n");
        sb.append(this.prefix).append(className).append(this.suffix);
        sb.append("## Optional\n");
        for (Field field : fieldList) {
            ApiModelProperty fieldContext = field.getAnnotation(ApiModelProperty.class);
            if (fieldContext == null) continue;
            field.setAccessible(true);
            String name = StringUtils.isBlank(fieldContext.name()) ? field.getName() : fieldContext.name();
            sb.append("### ").append(name).append("\n");
            sb.append(fieldContext.value().replace(">", "\\>")).append("\n\n");
            sb.append("**Default**: `").append(field.get(obj)).append("`\n\n");
        }
        return sb.toString();
    }

    public JCommander getJcommander() {
        return this.jcommander;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public boolean isHelp() {
        return this.help;
    }

    public Predicate<Field> getIsRequired() {
        return this.isRequired;
    }

    public Predicate<Field> getIsOptional() {
        return this.isOptional;
    }

    public Predicate<Field> getIsDeprecated() {
        return this.isDeprecated;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setJcommander(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    public void setClassNames(List<String> classNames) {
        this.classNames = classNames;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public void setIsRequired(Predicate<Field> isRequired) {
        this.isRequired = isRequired;
    }

    public void setIsOptional(Predicate<Field> isOptional) {
        this.isOptional = isOptional;
    }

    public void setIsDeprecated(Predicate<Field> isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseGenerateDocumentation)) {
            return false;
        }
        BaseGenerateDocumentation other = (BaseGenerateDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHelp() != other.isHelp()) {
            return false;
        }
        JCommander this$jcommander = this.getJcommander();
        JCommander other$jcommander = other.getJcommander();
        if (this$jcommander == null ? other$jcommander != null : !this$jcommander.equals(other$jcommander)) {
            return false;
        }
        List<String> this$classNames = this.getClassNames();
        List<String> other$classNames = other.getClassNames();
        if (this$classNames == null ? other$classNames != null : !((Object)this$classNames).equals(other$classNames)) {
            return false;
        }
        Predicate<Field> this$isRequired = this.getIsRequired();
        Predicate<Field> other$isRequired = other.getIsRequired();
        if (this$isRequired == null ? other$isRequired != null : !this$isRequired.equals(other$isRequired)) {
            return false;
        }
        Predicate<Field> this$isOptional = this.getIsOptional();
        Predicate<Field> other$isOptional = other.getIsOptional();
        if (this$isOptional == null ? other$isOptional != null : !this$isOptional.equals(other$isOptional)) {
            return false;
        }
        Predicate<Field> this$isDeprecated = this.getIsDeprecated();
        Predicate<Field> other$isDeprecated = other.getIsDeprecated();
        if (this$isDeprecated == null ? other$isDeprecated != null : !this$isDeprecated.equals(other$isDeprecated)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseGenerateDocumentation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHelp() ? 79 : 97);
        JCommander $jcommander = this.getJcommander();
        result = result * 59 + ($jcommander == null ? 43 : $jcommander.hashCode());
        List<String> $classNames = this.getClassNames();
        result = result * 59 + ($classNames == null ? 43 : ((Object)$classNames).hashCode());
        Predicate<Field> $isRequired = this.getIsRequired();
        result = result * 59 + ($isRequired == null ? 43 : $isRequired.hashCode());
        Predicate<Field> $isOptional = this.getIsOptional();
        result = result * 59 + ($isOptional == null ? 43 : $isOptional.hashCode());
        Predicate<Field> $isDeprecated = this.getIsDeprecated();
        result = result * 59 + ($isDeprecated == null ? 43 : $isDeprecated.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        return result;
    }

    public String toString() {
        return "BaseGenerateDocumentation(jcommander=" + this.getJcommander() + ", classNames=" + this.getClassNames() + ", help=" + this.isHelp() + ", isRequired=" + this.getIsRequired() + ", isOptional=" + this.getIsOptional() + ", isDeprecated=" + this.getIsDeprecated() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ")";
    }

    protected static class CategoryComparator
    implements Comparator<Field> {
        protected CategoryComparator() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            FieldContext o1Context = o1.getAnnotation(FieldContext.class);
            FieldContext o2Context = o2.getAnnotation(FieldContext.class);
            if (o1Context.category().equals(o2Context.category())) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1Context.category().compareTo(o2Context.category());
        }
    }
}

