/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.org.apache.bookkeeper.feature.Feature;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;

public class SimplePermitLimiter
implements PermitLimiter {
    final Counter acquireFailureCounter;
    final OpStatsLogger permitsMetric;
    private static final AtomicIntegerFieldUpdater<SimplePermitLimiter> permitsUpdater = AtomicIntegerFieldUpdater.newUpdater(SimplePermitLimiter.class, "permits");
    volatile int permits = 0;
    final int permitsMax;
    final boolean darkmode;
    final Feature disableWriteLimitFeature;
    private StatsLogger statsLogger = null;
    private Gauge<Number> permitsGauge = null;
    private String permitsGaugeLabel = "";

    public SimplePermitLimiter(boolean darkmode, int permitsMax, StatsLogger statsLogger, boolean singleton, Feature disableWriteLimitFeature) {
        this.permitsMax = permitsMax;
        this.darkmode = darkmode;
        this.disableWriteLimitFeature = disableWriteLimitFeature;
        if (singleton) {
            this.statsLogger = statsLogger;
            this.permitsGauge = new Gauge<Number>(){

                @Override
                public Number getDefaultValue() {
                    return 0;
                }

                @Override
                public Number getSample() {
                    return permitsUpdater.get(SimplePermitLimiter.this);
                }
            };
            this.permitsGaugeLabel = "permits";
            statsLogger.registerGauge(this.permitsGaugeLabel, this.permitsGauge);
        }
        this.acquireFailureCounter = statsLogger.getCounter("acquireFailure");
        this.permitsMetric = statsLogger.getOpStatsLogger("permits");
    }

    public boolean isDarkmode() {
        return this.darkmode || this.disableWriteLimitFeature.isAvailable();
    }

    @Override
    public boolean acquire() {
        this.permitsMetric.registerSuccessfulValue(permitsUpdater.get(this));
        if (permitsUpdater.incrementAndGet(this) <= this.permitsMax || this.isDarkmode()) {
            return true;
        }
        this.acquireFailureCounter.inc();
        permitsUpdater.decrementAndGet(this);
        return false;
    }

    @Override
    public void release(int permitsToRelease) {
        permitsUpdater.addAndGet(this, -permitsToRelease);
    }

    @Override
    public void close() {
        this.unregisterGauge();
    }

    @VisibleForTesting
    public int getPermits() {
        return permitsUpdater.get(this);
    }

    public void unregisterGauge() {
        if (this.statsLogger != null && this.permitsGauge != null) {
            this.statsLogger.unregisterGauge(this.permitsGaugeLabel, this.permitsGauge);
        }
    }
}

