/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.net;

import java.util.List;
import org.apache.distributedlog.net.DNSResolverForRacks;
import org.apache.distributedlog.net.NetUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.junit.Assert;
import org.junit.Test;

public class TestNetUtils {
    @Test(timeout=20000L)
    public void testGetDNSResolverWithOverrides() throws Exception {
        DNSToSwitchMapping dnsResolver = NetUtils.getDNSResolver(DNSResolverForRacks.class, "");
        Assert.assertEquals((String)("Should succeed to load " + DNSResolverForRacks.class), dnsResolver.getClass(), DNSResolverForRacks.class);
    }

    @Test(timeout=20000L)
    public void testGetDNSResolverWithDefaultConstructor() throws Exception {
        DNSToSwitchMapping dnsResolver = NetUtils.getDNSResolver(DNSResolverWithDefaultConstructor.class, "");
        Assert.assertEquals((String)("Should succeed to load " + DNSResolverWithDefaultConstructor.class), dnsResolver.getClass(), DNSResolverWithDefaultConstructor.class);
    }

    @Test(timeout=20000L, expected=RuntimeException.class)
    public void testGetDNSResolverWithUnknownConstructor() throws Exception {
        NetUtils.getDNSResolver(DNSResolverWithUnknownConstructor.class, "");
    }

    static class DNSResolverWithUnknownConstructor
    implements DNSToSwitchMapping {
        public DNSResolverWithUnknownConstructor(int var1, int var2, int var3) {
        }

        @Override
        public List<String> resolve(List<String> list) {
            return list;
        }

        @Override
        public void reloadCachedMappings() {
        }
    }

    static class DNSResolverWithDefaultConstructor
    implements DNSToSwitchMapping {
        @Override
        public List<String> resolve(List<String> list) {
            return list;
        }

        @Override
        public void reloadCachedMappings() {
        }
    }
}

