/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.namespace;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.namespace.NamespaceDriver;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceDriverManager {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceDriverManager.class);
    private static final ConcurrentMap<String, NamespaceDriverInfo> drivers;
    private static boolean initialized;

    static void initialize() {
        if (initialized) {
            return;
        }
        NamespaceDriverManager.loadInitialDrivers();
        initialized = true;
        logger.info("DistributedLog NamespaceDriverManager initialized");
    }

    private static void loadInitialDrivers() {
        HashSet<String> driverList = Sets.newHashSet();
        driverList.add(BKNamespaceDriver.class.getName());
        String driversStr = System.getProperty("distributedlog.namespace.drivers");
        if (null != driversStr) {
            String[] driversArray = StringUtils.split(driversStr, ':');
            driverList.addAll(Arrays.asList(driversArray));
        }
        for (String driverClsName : driverList) {
            try {
                NamespaceDriver driver = ReflectionUtils.newInstance(driverClsName, NamespaceDriver.class);
                NamespaceDriverInfo driverInfo = new NamespaceDriverInfo(driver.getClass());
                drivers.put(driver.getScheme().toLowerCase(), driverInfo);
            }
            catch (Exception ex) {
                logger.warn("Failed to load namespace driver {} : ", (Object)driverClsName, (Object)ex);
            }
        }
    }

    private NamespaceDriverManager() {
    }

    public static void registerDriver(String backend, Class<? extends NamespaceDriver> driver) {
        String scheme;
        NamespaceDriverInfo oldDriverInfo;
        if (!initialized) {
            NamespaceDriverManager.initialize();
        }
        if (null != (oldDriverInfo = (NamespaceDriverInfo)drivers.get(scheme = backend.toLowerCase()))) {
            return;
        }
        NamespaceDriverInfo newDriverInfo = new NamespaceDriverInfo(driver);
        oldDriverInfo = drivers.putIfAbsent(scheme, newDriverInfo);
        if (null != oldDriverInfo) {
            logger.debug("Driver for {} is already there.", (Object)scheme);
        }
    }

    public static NamespaceDriver getDriver(String scheme) {
        NamespaceDriverInfo driverInfo;
        Preconditions.checkNotNull(scheme, "Driver Scheme is null");
        if (!initialized) {
            NamespaceDriverManager.initialize();
        }
        if (null == (driverInfo = (NamespaceDriverInfo)drivers.get(scheme.toLowerCase()))) {
            throw new IllegalArgumentException("Unknown backend " + scheme);
        }
        return ReflectionUtils.newInstance(driverInfo.driverClass);
    }

    public static NamespaceDriver getDriver(URI uri) {
        Preconditions.checkNotNull(uri, "DistributedLog uri is null");
        String scheme = uri.getScheme();
        Preconditions.checkNotNull(scheme, "Invalid distributedlog uri : " + uri);
        scheme = scheme.toLowerCase();
        String[] schemeParts = StringUtils.split(scheme, '-');
        Preconditions.checkArgument(schemeParts.length > 0, "Invalid distributedlog scheme found : " + uri);
        Preconditions.checkArgument(Objects.equal("distributedlog", schemeParts[0].toLowerCase()), "Unknown distributedlog scheme found : " + uri);
        String backend = "bk";
        if (schemeParts.length > 1) {
            backend = schemeParts[1];
        }
        return NamespaceDriverManager.getDriver(backend);
    }

    static {
        initialized = false;
        drivers = new ConcurrentHashMap<String, NamespaceDriverInfo>();
        NamespaceDriverManager.initialize();
    }

    static class NamespaceDriverInfo {
        final Class<? extends NamespaceDriver> driverClass;
        final String driverClassName;

        NamespaceDriverInfo(Class<? extends NamespaceDriver> driverClass) {
            this.driverClass = driverClass;
            this.driverClassName = this.driverClass.getName();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("driver[").append(this.driverClassName).append("]");
            return sb.toString();
        }
    }
}

