/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.logsegment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.logsegment.PerStreamLogSegmentCache;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestPerStreamLogSegmentCache {
    @Test(timeout=60000L)
    public void testBasicOperations() {
        LogSegmentMetadata metadata = DLMTestUtil.completedLogSegment("/segment1", 1L, 1L, 100L, 100, 1L, 99L, 0L);
        String name = DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(1L);
        PerStreamLogSegmentCache cache = new PerStreamLogSegmentCache("test-basic-operations");
        Assert.assertNull((String)("No log segment " + name + " should be cached"), (Object)cache.get(name));
        cache.add(name, metadata);
        LogSegmentMetadata metadataRetrieved = cache.get(name);
        Assert.assertNotNull((String)("log segment " + name + " should be cached"), (Object)metadataRetrieved);
        Assert.assertEquals((String)("Wrong log segment metadata returned for " + name), (Object)metadata, (Object)metadataRetrieved);
        LogSegmentMetadata metadataRemoved = cache.remove(name);
        Assert.assertNull((String)("log segment " + name + " should be removed from cache"), (Object)cache.get(name));
        Assert.assertEquals((String)("Wrong log segment metadata removed for " + name), (Object)metadata, (Object)metadataRemoved);
        Assert.assertNull((String)("No log segment " + name + " to be removed"), (Object)cache.remove(name));
    }

    @Test(timeout=60000L)
    public void testDiff() {
        PerStreamLogSegmentCache cache = new PerStreamLogSegmentCache("test-diff");
        for (int i = 1; i <= 5; ++i) {
            LogSegmentMetadata metadata = DLMTestUtil.completedLogSegment("/segment" + i, i, i, (long)i * 100L, 100, i, 99L, 0L);
            String name = DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i);
            cache.add(name, metadata);
        }
        LogSegmentMetadata inprogress = DLMTestUtil.inprogressLogSegment("/inprogress-6", 6L, 600L, 6L);
        String name = DLMTestUtil.inprogressZNodeName(6L);
        cache.add(name, inprogress);
        HashSet<String> segmentRemoved = Sets.newHashSet();
        for (int i = 1; i <= 2; ++i) {
            segmentRemoved.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i));
        }
        segmentRemoved.add(DLMTestUtil.inprogressZNodeName(6L));
        HashSet<String> segmentReceived = Sets.newHashSet();
        HashSet<String> segmentAdded = Sets.newHashSet();
        for (int i = 3; i <= 6; ++i) {
            segmentReceived.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i));
            if (i != 6) continue;
            segmentAdded.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i));
        }
        Pair<Set<String>, Set<String>> segmentChanges = cache.diff(segmentReceived);
        Assert.assertTrue((String)("Should remove " + segmentRemoved + ", but removed " + segmentChanges.getRight()), (boolean)Sets.difference(segmentRemoved, segmentChanges.getRight()).isEmpty());
        Assert.assertTrue((String)("Should add " + segmentAdded + ", but added " + segmentChanges.getLeft()), (boolean)Sets.difference(segmentAdded, segmentChanges.getLeft()).isEmpty());
    }

    @Test(timeout=60000L)
    public void testUpdate() {
        PerStreamLogSegmentCache cache = new PerStreamLogSegmentCache("test-update");
        for (int i = 1; i <= 5; ++i) {
            LogSegmentMetadata metadata = DLMTestUtil.completedLogSegment("/segment" + i, i, i, (long)i * 100L, 100, i, 99L, 0L);
            String name = DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i);
            cache.add(name, metadata);
        }
        LogSegmentMetadata inprogress = DLMTestUtil.inprogressLogSegment("/inprogress-6", 6L, 600L, 6L);
        String name = DLMTestUtil.inprogressZNodeName(6L);
        cache.add(name, inprogress);
        HashSet<String> segmentRemoved = Sets.newHashSet();
        for (int i = 1; i <= 2; ++i) {
            segmentRemoved.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i));
        }
        segmentRemoved.add(DLMTestUtil.inprogressZNodeName(6L));
        HashSet<String> segmentReceived = Sets.newHashSet();
        HashMap<String, LogSegmentMetadata> segmentAdded = Maps.newHashMap();
        for (int i = 3; i <= 6; ++i) {
            segmentReceived.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i));
            if (i != 6) continue;
            segmentAdded.put(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i), DLMTestUtil.completedLogSegment("/segment" + i, i, i, (long)i * 100L, 100, i, 99L, 0L));
        }
        cache.update(segmentRemoved, segmentAdded);
        for (String string : segmentRemoved) {
            Assert.assertNull((String)("Segment " + string + " should be removed."), (Object)cache.get(string));
        }
        for (String string : segmentReceived) {
            Assert.assertNotNull((String)("Segment " + string + " should not be removed"), (Object)cache.get(string));
        }
        for (Map.Entry entry : segmentAdded.entrySet()) {
            Assert.assertEquals((String)("Segment " + (String)entry.getKey() + " should be added."), entry.getValue(), entry.getValue());
        }
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testGapDetection() throws Exception {
        PerStreamLogSegmentCache cache = new PerStreamLogSegmentCache("test-gap-detection");
        cache.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(1L), DLMTestUtil.completedLogSegment("/segment-1", 1L, 1L, 100L, 100, 1L, 99L, 0L));
        cache.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(3L), DLMTestUtil.completedLogSegment("/segment-3", 3L, 3L, 300L, 100, 3L, 99L, 0L));
        cache.getLogSegments(LogSegmentMetadata.COMPARATOR);
    }

    @Test(timeout=60000L)
    public void testGapDetectionOnLogSegmentsWithoutLogSegmentSequenceNumber() throws Exception {
        PerStreamLogSegmentCache cache = new PerStreamLogSegmentCache("test-gap-detection");
        LogSegmentMetadata segment1 = DLMTestUtil.completedLogSegment("/segment-1", 1L, 1L, 100L, 100, 1L, 99L, 0L).mutator().setVersion(LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V1_ORIGINAL).build();
        cache.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(1L), segment1);
        LogSegmentMetadata segment3 = DLMTestUtil.completedLogSegment("/segment-3", 3L, 3L, 300L, 100, 3L, 99L, 0L).mutator().setVersion(LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO).build();
        cache.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(3L), segment3);
        List<LogSegmentMetadata> expectedList = Lists.asList(segment1, new LogSegmentMetadata[]{segment3});
        List<LogSegmentMetadata> resultList = cache.getLogSegments(LogSegmentMetadata.COMPARATOR);
        Assert.assertEquals(expectedList, resultList);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testSameLogSegment() throws Exception {
        PerStreamLogSegmentCache cache = new PerStreamLogSegmentCache("test-same-log-segment");
        ArrayList<LogSegmentMetadata> expectedList = Lists.newArrayListWithExpectedSize(2);
        LogSegmentMetadata inprogress = DLMTestUtil.inprogressLogSegment("/inprogress-1", 1L, 1L, 1L);
        expectedList.add(inprogress);
        cache.add(DLMTestUtil.inprogressZNodeName(1L), inprogress);
        LogSegmentMetadata completed = DLMTestUtil.completedLogSegment("/segment-1", 1L, 1L, 100L, 100, 1L, 99L, 0L);
        expectedList.add(completed);
        cache.add(DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(1L), completed);
        cache.getLogSegments(LogSegmentMetadata.COMPARATOR);
    }
}

