/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.logsegment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerStreamLogSegmentCache {
    static final Logger LOG = LoggerFactory.getLogger(PerStreamLogSegmentCache.class);
    protected final String streamName;
    protected final boolean validateLogSegmentSequenceNumber;
    protected final Map<String, LogSegmentMetadata> logSegments = new HashMap<String, LogSegmentMetadata>();
    protected final ConcurrentMap<Long, LogSegmentMetadata> lid2LogSegments = new ConcurrentHashMap<Long, LogSegmentMetadata>();

    @VisibleForTesting
    PerStreamLogSegmentCache(String streamName) {
        this(streamName, true);
    }

    public PerStreamLogSegmentCache(String streamName, boolean validateLogSegmentSequenceNumber) {
        this.streamName = streamName;
        this.validateLogSegmentSequenceNumber = validateLogSegmentSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogSegmentMetadata> getLogSegments(Comparator<LogSegmentMetadata> comparator) throws UnexpectedException {
        ArrayList<LogSegmentMetadata> segmentsToReturn;
        Map<String, LogSegmentMetadata> map = this.logSegments;
        synchronized (map) {
            segmentsToReturn = new ArrayList<LogSegmentMetadata>(this.logSegments.size());
            segmentsToReturn.addAll(this.logSegments.values());
        }
        Collections.sort(segmentsToReturn, LogSegmentMetadata.COMPARATOR);
        LogSegmentMetadata prevSegment = null;
        if (this.validateLogSegmentSequenceNumber) {
            for (int i = 0; i < segmentsToReturn.size(); ++i) {
                LogSegmentMetadata segment = (LogSegmentMetadata)segmentsToReturn.get(i);
                if (null != prevSegment && prevSegment.getVersion() >= LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO.value && segment.getVersion() >= LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO.value && prevSegment.getLogSegmentSequenceNumber() + 1L != segment.getLogSegmentSequenceNumber()) {
                    LOG.error("{} found ledger sequence number gap between log segment {} and {}", new Object[]{this.streamName, prevSegment, segment});
                    throw new UnexpectedException(this.streamName + " found ledger sequence number gap between log segment " + prevSegment.getLogSegmentSequenceNumber() + " and " + segment.getLogSegmentSequenceNumber());
                }
                prevSegment = segment;
            }
        }
        prevSegment = null;
        long startSequenceId = -1L;
        for (int i = 0; i < segmentsToReturn.size(); ++i) {
            LogSegmentMetadata segment = (LogSegmentMetadata)segmentsToReturn.get(i);
            if (segment.isInProgress()) {
                if (!segment.supportsSequenceId()) break;
                LogSegmentMetadata newSegment = segment.mutator().setStartSequenceId(startSequenceId == -1L ? 0L : startSequenceId).build();
                segmentsToReturn.set(i, newSegment);
                break;
            }
            if (segment.supportsSequenceId()) {
                startSequenceId = segment.getStartSequenceId() + (long)segment.getRecordCount();
                if (null != prevSegment && prevSegment.supportsSequenceId() && prevSegment.getStartSequenceId() > segment.getStartSequenceId()) {
                    LOG.warn("{} found decreasing start sequence id in log segment {}, previous is {}", new Object[]{this.streamName, segment, prevSegment});
                }
            } else {
                startSequenceId = -1L;
            }
            prevSegment = segment;
        }
        if (comparator != LogSegmentMetadata.COMPARATOR) {
            Collections.sort(segmentsToReturn, comparator);
        }
        return segmentsToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, LogSegmentMetadata metadata) {
        Map<String, LogSegmentMetadata> map = this.logSegments;
        synchronized (map) {
            LogSegmentMetadata oldMetadata;
            if (!this.logSegments.containsKey(name)) {
                this.logSegments.put(name, metadata);
                LOG.info("{} added log segment ({} : {}) to cache.", new Object[]{this.streamName, name, metadata});
            }
            if (null == (oldMetadata = (LogSegmentMetadata)this.lid2LogSegments.remove(metadata.getLogSegmentId()))) {
                this.lid2LogSegments.put(metadata.getLogSegmentId(), metadata);
            } else if (oldMetadata.isInProgress() && !metadata.isInProgress()) {
                this.lid2LogSegments.put(metadata.getLogSegmentId(), metadata);
            } else {
                this.lid2LogSegments.put(oldMetadata.getLogSegmentId(), oldMetadata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogSegmentMetadata get(String name) {
        Map<String, LogSegmentMetadata> map = this.logSegments;
        synchronized (map) {
            return this.logSegments.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Set<String> segmentsRemoved, Map<String, LogSegmentMetadata> segmentsAdded) {
        Map<String, LogSegmentMetadata> map = this.logSegments;
        synchronized (map) {
            for (Map.Entry<String, LogSegmentMetadata> entry : segmentsAdded.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
            for (String segment : segmentsRemoved) {
                this.remove(segment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<String>, Set<String>> diff(Set<String> segmentsReceived) {
        ImmutableSet<String> segmentsRemoved;
        ImmutableSet<String> segmentsAdded;
        Map<String, LogSegmentMetadata> map = this.logSegments;
        synchronized (map) {
            Set<String> segmentsCached = this.logSegments.keySet();
            segmentsAdded = Sets.difference(segmentsReceived, segmentsCached).immutableCopy();
            segmentsRemoved = Sets.difference(segmentsCached, segmentsReceived).immutableCopy();
        }
        return Pair.of(segmentsAdded, segmentsRemoved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogSegmentMetadata remove(String name) {
        Map<String, LogSegmentMetadata> map = this.logSegments;
        synchronized (map) {
            LogSegmentMetadata metadata = this.logSegments.remove(name);
            if (null != metadata) {
                this.lid2LogSegments.remove(metadata.getLogSegmentId(), metadata);
                LOG.debug("Removed log segment ({} : {}) from cache.", (Object)name, (Object)metadata);
            }
            return metadata;
        }
    }
}

