/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.distributedlog.common.functions.VoidFunctions;
import org.apache.distributedlog.io.Abortable;
import org.apache.distributedlog.io.AsyncAbortable;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Abortables {
    private static final Logger log = LoggerFactory.getLogger(Abortables.class);

    private Abortables() {
    }

    public static CompletableFuture<Void> asyncAbort(@Nullable AsyncAbortable abortable, boolean swallowIOException) {
        if (null == abortable) {
            return FutureUtils.Void();
        }
        if (swallowIOException) {
            return FutureUtils.ignore(abortable.asyncAbort());
        }
        return abortable.asyncAbort();
    }

    public static void abort(@Nullable Abortable abortable, boolean swallowIOException) throws IOException {
        if (null == abortable) {
            return;
        }
        try {
            abortable.abort();
        }
        catch (IOException ioe) {
            if (swallowIOException) {
                log.warn("IOException thrown while aborting Abortable {} : ", (Object)abortable, (Object)ioe);
            }
            throw ioe;
        }
    }

    public static void abort(@Nullable AsyncAbortable abortable, boolean swallowIOException) throws IOException {
        if (null == abortable) {
            return;
        }
        try {
            FutureUtils.result(abortable.asyncAbort());
        }
        catch (Exception e) {
            if (swallowIOException) {
                log.warn("IOException thrown while aborting Abortable {} : ", (Object)abortable, (Object)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public static void abortQuietly(@Nullable Abortable abortable) {
        try {
            Abortables.abort(abortable, true);
        }
        catch (IOException e) {
            log.error("Unexpected IOException thrown while aborting Abortable {} quietly : ", (Object)abortable, (Object)e);
        }
    }

    public static void abortQuietly(@Nullable AsyncAbortable abortable) {
        try {
            Abortables.abort(abortable, true);
        }
        catch (IOException e) {
            log.error("Unexpected IOException thrown while aborting Abortable {} quietly : ", (Object)abortable, (Object)e);
        }
    }

    public static CompletableFuture<Void> abortSequence(ExecutorService executorService, AsyncAbortable ... abortables) {
        ArrayList<AsyncAbortable> abortableList = Lists.newArrayListWithExpectedSize(abortables.length);
        for (AsyncAbortable abortable : abortables) {
            if (null == abortable) {
                abortableList.add(AsyncAbortable.NULL);
                continue;
            }
            abortableList.add(abortable);
        }
        return FutureUtils.processList(abortableList, AsyncAbortable.ABORT_FUNC, executorService).thenApply(VoidFunctions.LIST_TO_VOID_FUNC);
    }
}

