/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.metadata;

import java.io.IOException;
import java.net.URI;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.impl.metadata.ZkMetadataResolver;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.distributedlog.util.Utils;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZkMetadataResolver
extends ZooKeeperClusterTestCase {
    private static final BKDLConfig bkdlConfig = new BKDLConfig("127.0.0.1:7000", "ledgers");
    private static final BKDLConfig bkdlConfig2 = new BKDLConfig("127.0.0.1:7000", "ledgers2");
    private ZooKeeperClient zkc;
    private ZkMetadataResolver resolver;

    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createURI("/")).sessionTimeoutMs(10000).build();
        this.resolver = new ZkMetadataResolver(this.zkc);
    }

    @After
    public void tearDown() throws Exception {
        this.zkc.close();
    }

    private URI createURI(String path) {
        return URI.create("distributedlog://127.0.0.1:" + zkPort + path);
    }

    @Test(timeout=60000L)
    public void testResolveFailures() throws Exception {
        try {
            this.resolver.resolve(this.createURI("/unexisted/path"));
            Assert.fail((String)"Should fail if no metadata resolved.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Utils.zkCreateFullPathOptimistic(this.zkc, "/existed/path", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.resolver.resolve(this.createURI("/existed/path"));
            Assert.fail((String)"Should fail if no metadata resolved.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testResolve() throws Exception {
        DLMetadata dlMetadata = DLMetadata.create(bkdlConfig);
        dlMetadata.create(this.createURI("/messaging/distributedlog-testresolve"));
        DLMetadata dlMetadata2 = DLMetadata.create(bkdlConfig2);
        dlMetadata2.create(this.createURI("/messaging/distributedlog-testresolve/child"));
        Assert.assertEquals((Object)dlMetadata, (Object)this.resolver.resolve(this.createURI("/messaging/distributedlog-testresolve")));
        Assert.assertEquals((Object)dlMetadata2, (Object)this.resolver.resolve(this.createURI("/messaging/distributedlog-testresolve/child")));
        Assert.assertEquals((Object)dlMetadata2, (Object)this.resolver.resolve(this.createURI("/messaging/distributedlog-testresolve/child/unknown")));
        Utils.zkCreateFullPathOptimistic(this.zkc, "/messaging/distributedlog-testresolve/child/child2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertEquals((Object)dlMetadata2, (Object)this.resolver.resolve(this.createURI("/messaging/distributedlog-testresolve/child/child2")));
    }

    @Test(timeout=60000L)
    public void testEncodeRegionID() throws Exception {
        DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
        URI uri = this.createURI("/messaging/distributedlog-testencoderegionid/dl1");
        DLMetadata meta1 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers"));
        meta1.create(uri);
        BKDLConfig read1 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read1, dlConf);
        Assert.assertFalse((boolean)dlConf.getEncodeRegionIDInLogSegmentMetadata());
        BKDLConfig.clearCachedDLConfigs();
        DLMetadata meta2 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers").setEncodeRegionID(true));
        meta2.update(uri);
        BKDLConfig read2 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read2, dlConf);
        Assert.assertTrue((boolean)dlConf.getEncodeRegionIDInLogSegmentMetadata());
        BKDLConfig.clearCachedDLConfigs();
        DLMetadata meta3 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers").setEncodeRegionID(false));
        meta3.update(uri);
        BKDLConfig read3 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read3, dlConf);
        Assert.assertFalse((boolean)dlConf.getEncodeRegionIDInLogSegmentMetadata());
        BKDLConfig.clearCachedDLConfigs();
    }

    @Test(timeout=60000L)
    public void testFirstLogSegmentSequenceNumber() throws Exception {
        DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
        URI uri = this.createURI("/messaging/distributedlog-testfirstledgerseqno/dl1");
        DLMetadata meta1 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers"));
        meta1.create(uri);
        BKDLConfig read1 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read1, dlConf);
        Assert.assertEquals((long)1L, (long)dlConf.getFirstLogSegmentSequenceNumber());
        BKDLConfig.clearCachedDLConfigs();
        DLMetadata meta2 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers").setFirstLogSegmentSeqNo(9999L));
        meta2.update(uri);
        BKDLConfig read2 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read2, dlConf);
        Assert.assertEquals((long)9999L, (long)dlConf.getFirstLogSegmentSequenceNumber());
        BKDLConfig.clearCachedDLConfigs();
        DLMetadata meta3 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers").setFirstLogSegmentSeqNo(99L));
        meta3.update(uri);
        BKDLConfig read3 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read3, dlConf);
        Assert.assertEquals((long)99L, (long)dlConf.getFirstLogSegmentSequenceNumber());
        BKDLConfig.clearCachedDLConfigs();
    }

    @Test(timeout=60000L)
    public void testFederatedNamespace() throws Exception {
        DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
        URI uri = this.createURI("/messaging/distributedlog-testfederatednamespace/dl1");
        DLMetadata meta1 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers"));
        meta1.create(uri);
        BKDLConfig read1 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read1, dlConf);
        Assert.assertTrue((boolean)dlConf.getCreateStreamIfNotExists());
        BKDLConfig.clearCachedDLConfigs();
        DLMetadata meta2 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers").setFederatedNamespace(true));
        meta2.update(uri);
        BKDLConfig read2 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read2, dlConf);
        Assert.assertFalse((boolean)dlConf.getCreateStreamIfNotExists());
        BKDLConfig.clearCachedDLConfigs();
        DLMetadata meta3 = DLMetadata.create(new BKDLConfig("127.0.0.1:7000", "ledgers").setFederatedNamespace(false));
        meta3.update(uri);
        BKDLConfig read3 = BKDLConfig.resolveDLConfig(this.zkc, uri);
        BKDLConfig.propagateConfiguration(read3, dlConf);
        Assert.assertFalse((boolean)dlConf.getCreateStreamIfNotExists());
        BKDLConfig.clearCachedDLConfigs();
    }
}

