/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.metadata;

import java.net.URI;
import java.util.ArrayList;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.impl.metadata.ZKLogStreamMetadataStore;
import org.apache.distributedlog.metadata.LogMetadataForWriter;
import org.apache.distributedlog.util.DLUtils;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.LongVersion;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.junit.Assert;
import org.junit.Test;

public class TestZKLogStreamMetadataStoreUtils {
    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingMaxTxnId() throws Exception {
        String rootPath = "/test-missing-max-txn-id";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), new Versioned<Object>(null, null));
        ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingVersion() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L)), new Versioned<Object>(null, null));
        ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasWrongVersion() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L)), new Versioned<byte[]>(ZKLogStreamMetadataStore.intToBytes(9999), null));
        ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingLockPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L)), new Versioned<byte[]>(ZKLogStreamMetadataStore.intToBytes(-1), null), new Versioned<Object>(null, null));
        ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingReadLockPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L)), new Versioned<byte[]>(ZKLogStreamMetadataStore.intToBytes(-1), null), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), new Versioned<Object>(null, null));
        ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingLogSegmentsPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L)), new Versioned<byte[]>(ZKLogStreamMetadataStore.intToBytes(-1), null), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), new Versioned<Object>(null, null));
        ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingAllocatorPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L)), new Versioned<byte[]>(ZKLogStreamMetadataStore.intToBytes(-1), null), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), new Versioned<byte[]>(DLUtils.serializeLogSegmentSequenceNumber(1L), new LongVersion(1L)), new Versioned<Object>(null, null));
        ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, true);
    }

    @Test(timeout=60000L)
    public void testProcessLogMetadatasNoAllocatorPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        Versioned<byte[]> maxTxnIdData = new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L));
        Versioned<byte[]> logSegmentsData = new Versioned<byte[]>(DLUtils.serializeLogSegmentSequenceNumber(1L), new LongVersion(1L));
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), maxTxnIdData, new Versioned<byte[]>(ZKLogStreamMetadataStore.intToBytes(-1), null), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), logSegmentsData);
        LogMetadataForWriter metadata = ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, false);
        Assert.assertTrue((maxTxnIdData == metadata.getMaxTxIdData() ? 1 : 0) != 0);
        Assert.assertTrue((logSegmentsData == metadata.getMaxLSSNData() ? 1 : 0) != 0);
        Assert.assertNull((Object)metadata.getAllocationData().getValue());
        Assert.assertNull((Object)metadata.getAllocationData().getVersion());
    }

    @Test(timeout=60000L)
    public void testProcessLogMetadatasAllocatorPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        Versioned<byte[]> maxTxnIdData = new Versioned<byte[]>(DLUtils.serializeTransactionId(1L), new LongVersion(1L));
        Versioned<byte[]> logSegmentsData = new Versioned<byte[]>(DLUtils.serializeLogSegmentSequenceNumber(1L), new LongVersion(1L));
        Versioned<byte[]> allocationData = new Versioned<byte[]>(DLUtils.logSegmentId2Bytes(1L), new LongVersion(1L));
        ArrayList<Versioned<byte[]>> metadatas = Lists.newArrayList(new Versioned<Object>(null, null), new Versioned<Object>(null, null), maxTxnIdData, new Versioned<byte[]>(ZKLogStreamMetadataStore.intToBytes(-1), null), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), new Versioned<byte[]>(new byte[0], new LongVersion(1L)), logSegmentsData, allocationData);
        LogMetadataForWriter metadata = ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, true);
        Assert.assertTrue((maxTxnIdData == metadata.getMaxTxIdData() ? 1 : 0) != 0);
        Assert.assertTrue((logSegmentsData == metadata.getMaxLSSNData() ? 1 : 0) != 0);
        Assert.assertTrue((allocationData == metadata.getAllocationData() ? 1 : 0) != 0);
    }
}

