/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.logsegment;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.common.functions.VoidFunctions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.AsyncCallback;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;

public class BKUtils {
    public static CompletableFuture<Void> closeLedger(LedgerHandle lh) {
        final CompletableFuture<Void> closePromise = new CompletableFuture<Void>();
        lh.asyncClose(new AsyncCallback.CloseCallback(){

            @Override
            public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                if (0 != rc) {
                    FutureUtils.completeExceptionally(closePromise, BKException.create(rc));
                } else {
                    FutureUtils.complete(closePromise, null);
                }
            }
        }, null);
        return closePromise;
    }

    public static CompletableFuture<Void> closeLedgers(LedgerHandle ... lhs) {
        ArrayList closeResults = Lists.newArrayListWithExpectedSize(lhs.length);
        for (LedgerHandle lh : lhs) {
            closeResults.add(BKUtils.closeLedger(lh));
        }
        return FutureUtils.collect(closeResults).thenApply(VoidFunctions.LIST_TO_VOID_FUNC);
    }
}

