/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.impl.ZKLogSegmentFilters;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKLogSegmentFilters {
    static final Logger LOG = LoggerFactory.getLogger(TestZKLogSegmentFilters.class);

    @Test(timeout=60000L)
    public void testWriteFilter() {
        String segmentName;
        int i;
        HashSet<String> expectedFilteredSegments = new HashSet<String>();
        ArrayList<String> segments = new ArrayList<String>();
        for (i = 1; i <= 5; ++i) {
            segments.add(DLMTestUtil.completedLedgerZNodeNameWithVersion(i, (i - 1) * 100, i * 100 - 1, i));
        }
        for (i = 6; i <= 10; ++i) {
            segmentName = DLMTestUtil.completedLedgerZNodeNameWithLogSegmentSequenceNumber(i);
            segments.add(segmentName);
            if (i != 10) continue;
            expectedFilteredSegments.add(segmentName);
        }
        for (i = 11; i <= 15; ++i) {
            segmentName = DLMTestUtil.completedLedgerZNodeNameWithTxID((i - 1) * 100, i * 100 - 1);
            segments.add(segmentName);
            expectedFilteredSegments.add(segmentName);
        }
        segments.add("");
        segments.add("unknown");
        segments.add("logrecs_1234_5678_9");
        expectedFilteredSegments.add("logrecs_1234_5678_9");
        segments.add("logrecs_1_2_3_4_5_6_7_8_9");
        expectedFilteredSegments.add("logrecs_1_2_3_4_5_6_7_8_9");
        Collection<String> filteredCollection = ZKLogSegmentFilters.WRITE_HANDLE_FILTER.filter(segments);
        LOG.info("Filter log segments {} to {}.", segments, filteredCollection);
        Assert.assertEquals((long)expectedFilteredSegments.size(), (long)filteredCollection.size());
        HashSet<String> filteredSegments = Sets.newHashSet(filteredCollection);
        Sets.SetView<String> diff = Sets.difference(filteredSegments, expectedFilteredSegments);
        Assert.assertTrue((boolean)diff.isEmpty());
    }
}

