/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.impl.ZKLogMetadataStore;
import org.apache.distributedlog.util.Utils;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestZKLogMetadataStore
extends TestDistributedLogBase {
    private static final int zkSessionTimeoutMs = 2000;
    @Rule
    public TestName runtime = new TestName();
    protected final DistributedLogConfiguration baseConf = new DistributedLogConfiguration();
    protected ZooKeeperClient zkc;
    protected ZKLogMetadataStore metadataStore;
    protected OrderedScheduler scheduler;
    protected URI uri;

    @Override
    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createDLMURI("/")).sessionTimeoutMs(2000).build();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-zk-logmetadata-store").numThreads(1).build();
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.addConfiguration(this.baseConf);
        this.uri = this.createDLMURI("/" + this.runtime.getMethodName());
        this.metadataStore = new ZKLogMetadataStore(conf, this.uri, this.zkc, this.scheduler);
    }

    @Override
    @After
    public void teardown() throws Exception {
        if (null != this.zkc) {
            this.zkc.close();
        }
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    private void createLogInNamespace(URI uri, String logName) throws Exception {
        String logPath = uri.getPath() + "/" + logName;
        Utils.zkCreateFullPathOptimistic(this.zkc, logPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    @Test(timeout=60000L)
    public void testCreateLog() throws Exception {
        Assert.assertEquals((Object)this.uri, (Object)Utils.ioResult(this.metadataStore.createLog("test")));
    }

    @Test(timeout=60000L)
    public void testGetLogLocation() throws Exception {
        Optional<URI> uriOptional = Utils.ioResult(this.metadataStore.getLogLocation("test"));
        Assert.assertTrue((boolean)uriOptional.isPresent());
        Assert.assertEquals((Object)this.uri, (Object)uriOptional.get());
    }

    @Test(timeout=60000L)
    public void testGetLogs() throws Exception {
        HashSet<String> logs = Sets.newHashSet();
        for (int i = 0; i < 10; ++i) {
            String logName = "test-" + i;
            logs.add(logName);
            this.createLogInNamespace(this.uri, logName);
        }
        HashSet<String> result = Sets.newHashSet(Utils.ioResult(this.metadataStore.getLogs("")));
        Assert.assertEquals((long)10L, (long)result.size());
        Assert.assertTrue((boolean)Sets.difference(logs, result).isEmpty());
    }

    @Test(timeout=60000L)
    public void testGetLogsPrefix() throws Exception {
        HashSet<String> logs = Sets.newHashSet();
        for (int i = 0; i < 10; ++i) {
            String logName = "test-" + i;
            logs.add(logName);
            this.createLogInNamespace(this.uri, "test/" + logName);
        }
        HashSet<String> result = Sets.newHashSet(Utils.ioResult(this.metadataStore.getLogs("test")));
        Assert.assertEquals((long)10L, (long)result.size());
        Assert.assertTrue((boolean)Sets.difference(logs, result).isEmpty());
    }
}

