/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.config;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConcurrentConstConfiguration;
import org.apache.distributedlog.common.config.ConfigurationSubscription;
import org.apache.distributedlog.common.config.FileConfigurationBuilder;
import org.apache.distributedlog.common.config.PropertiesConfigurationBuilder;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicConfigurationFactory.class);
    private final Map<String, DynamicDistributedLogConfiguration> dynamicConfigs;
    private final List<ConfigurationSubscription> subscriptions;
    private final ScheduledExecutorService executorService;
    private final int reloadPeriod;
    private final TimeUnit reloadUnit;

    public DynamicConfigurationFactory(ScheduledExecutorService executorService, int reloadPeriod, TimeUnit reloadUnit) {
        this.executorService = executorService;
        this.reloadPeriod = reloadPeriod;
        this.reloadUnit = reloadUnit;
        this.dynamicConfigs = new HashMap<String, DynamicDistributedLogConfiguration>();
        this.subscriptions = new LinkedList<ConfigurationSubscription>();
    }

    public synchronized Optional<DynamicDistributedLogConfiguration> getDynamicConfiguration(String configPath, ConcurrentBaseConfiguration defaultConf) throws ConfigurationException {
        Preconditions.checkNotNull(configPath);
        try {
            if (!this.dynamicConfigs.containsKey(configPath)) {
                File configFile = new File(configPath);
                PropertiesConfigurationBuilder properties = new PropertiesConfigurationBuilder(configFile.toURI().toURL());
                DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConf);
                ArrayList<FileConfigurationBuilder> fileConfigBuilders = Lists.newArrayList(properties);
                ConfigurationSubscription subscription = new ConfigurationSubscription(dynConf, fileConfigBuilders, this.executorService, this.reloadPeriod, this.reloadUnit);
                this.subscriptions.add(subscription);
                this.dynamicConfigs.put(configPath, dynConf);
                LOG.info("Loaded dynamic configuration at {}", (Object)configPath);
            }
            return Optional.of(this.dynamicConfigs.get(configPath));
        }
        catch (MalformedURLException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public synchronized Optional<DynamicDistributedLogConfiguration> getDynamicConfiguration(String configPath) throws ConfigurationException {
        return this.getDynamicConfiguration(configPath, new ConcurrentConstConfiguration(new DistributedLogConfiguration()));
    }
}

