/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.common.rate;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.distributedlog.common.rate.MovingAverageRate;
import org.apache.pulsar.shade.com.google.common.base.Ticker;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;

class SampledMovingAverageRate
implements MovingAverageRate {
    private static final long NANOS_PER_SEC = TimeUnit.SECONDS.toNanos(1L);
    private final LongAdder total = new LongAdder();
    private final Ticker ticker;
    private final double scaleFactor;
    private final LinkedBlockingDeque<Pair<Long, Long>> samples;
    private double value = 0.0;

    public SampledMovingAverageRate(int intervalSecs) {
        this(intervalSecs, 1.0, Ticker.systemTicker());
    }

    SampledMovingAverageRate(int intervalSecs, double scaleFactor, Ticker ticker) {
        this.scaleFactor = scaleFactor;
        this.ticker = ticker;
        this.samples = new LinkedBlockingDeque(intervalSecs);
    }

    @Override
    public double get() {
        return this.value;
    }

    @Override
    public void add(long amount) {
        this.total.add(amount);
    }

    @Override
    public void inc() {
        this.add(1L);
    }

    void sample() {
        this.value = this.doSample();
    }

    private double doSample() {
        long newSample = this.total.sum();
        long newTimestamp = this.ticker.read();
        double rate = 0.0;
        if (!this.samples.isEmpty()) {
            Pair<Long, Long> oldestSample = this.samples.peekLast();
            double dy = newSample - oldestSample.getRight();
            double dt = newTimestamp - oldestSample.getLeft();
            double d = rate = dt == 0.0 ? 0.0 : (double)NANOS_PER_SEC * this.scaleFactor * dy / dt;
        }
        if (this.samples.remainingCapacity() == 0) {
            this.samples.removeLast();
        } else {
            this.samples.addFirst(Pair.of(newTimestamp, newSample));
        }
        return rate;
    }
}

