/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.zk.ZKWatcherManager;
import org.apache.pulsar.shade.com.google.common.base.Stopwatch;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.WatchedEvent;
import org.apache.pulsar.shade.org.apache.zookeeper.Watcher;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.shade.org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZooKeeperClient.class.getName());
    private final String name;
    private final int sessionTimeoutMs;
    private final int defaultConnectionTimeoutMs;
    private final String zooKeeperServers;
    private volatile ZooKeeper zooKeeper = null;
    private final RetryPolicy retryPolicy;
    private final StatsLogger statsLogger;
    private final int retryThreadCount;
    private final double requestRateLimit;
    private final Credentials credentials;
    private volatile boolean authenticated = false;
    private Stopwatch disconnectedStopwatch = null;
    private boolean closed = false;
    final Set<Watcher> watchers = new CopyOnWriteArraySet<Watcher>();
    private final ZKWatcherManager watcherManager;

    ZooKeeperClient(int sessionTimeoutMs, int connectionTimeoutMs, String zooKeeperServers) {
        this("default", sessionTimeoutMs, connectionTimeoutMs, zooKeeperServers, null, NullStatsLogger.INSTANCE, 1, 0.0, Credentials.NONE);
    }

    ZooKeeperClient(String name, int sessionTimeoutMs, int connectionTimeoutMs, String zooKeeperServers, RetryPolicy retryPolicy, StatsLogger statsLogger, int retryThreadCount, double requestRateLimit, Credentials credentials) {
        this.name = name;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.zooKeeperServers = zooKeeperServers;
        this.defaultConnectionTimeoutMs = connectionTimeoutMs;
        this.retryPolicy = retryPolicy;
        this.statsLogger = statsLogger;
        this.retryThreadCount = retryThreadCount;
        this.requestRateLimit = requestRateLimit;
        this.credentials = credentials;
        this.watcherManager = ZKWatcherManager.newBuilder().name(name).zkc(this).statsLogger(statsLogger.scope("watcher_manager")).build();
    }

    public List<ACL> getDefaultACL() {
        if (Credentials.NONE == this.credentials) {
            return ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        return DistributedLogConstants.EVERYONE_READ_CREATOR_ALL;
    }

    public ZKWatcherManager getWatcherManager() {
        return this.watcherManager;
    }

    public synchronized ZooKeeper get() throws ZooKeeperConnectionException, InterruptedException {
        try {
            FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_ZooKeeperConnectionLoss);
        }
        catch (IOException ioe) {
            throw new ZooKeeperConnectionException("Client " + this.name + " failed on establishing zookeeper connection", ioe);
        }
        if (this.closed) {
            throw new ZooKeeperConnectionException("Client " + this.name + " has already been closed");
        }
        if (this.zooKeeper != null && this.retryPolicy != null) {
            if (this.zooKeeper.getState().equals((Object)ZooKeeper.States.CONNECTED)) {
                this.disconnectedStopwatch = null;
            } else if (this.disconnectedStopwatch == null) {
                this.disconnectedStopwatch = Stopwatch.createStarted();
            } else {
                long disconnectedMs = this.disconnectedStopwatch.elapsed(TimeUnit.MILLISECONDS);
                if (disconnectedMs > (long)this.defaultConnectionTimeoutMs) {
                    this.closeInternal();
                    this.authenticated = false;
                }
            }
        }
        if (this.zooKeeper == null) {
            this.zooKeeper = this.buildZooKeeper();
            this.disconnectedStopwatch = null;
        }
        if (!this.authenticated) {
            this.credentials.authenticate(this.zooKeeper);
            this.authenticated = true;
        }
        return this.zooKeeper;
    }

    private ZooKeeper buildZooKeeper() throws ZooKeeperConnectionException, InterruptedException {
        org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.ZooKeeperClient zk;
        Watcher watcher = new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                block2 : switch (event.getType()) {
                    case None: {
                        switch (event.getState()) {
                            case Expired: {
                                if (null == ZooKeeperClient.this.retryPolicy) {
                                    LOG.info("ZooKeeper {}' session expired. Event: {}", (Object)ZooKeeperClient.this.name, (Object)event);
                                    ZooKeeperClient.this.closeInternal();
                                }
                                ZooKeeperClient.this.authenticated = false;
                                break block2;
                            }
                            case Disconnected: {
                                if (null == ZooKeeperClient.this.retryPolicy) {
                                    LOG.info("ZooKeeper {} is disconnected from zookeeper now, but it is OK unless we received EXPIRED event.", (Object)ZooKeeperClient.this.name);
                                }
                                ZooKeeperClient.this.authenticated = false;
                                break block2;
                            }
                        }
                    }
                }
                try {
                    for (Watcher watcher : ZooKeeperClient.this.watchers) {
                        try {
                            watcher.process(event);
                        }
                        catch (Throwable t) {
                            LOG.warn("Encountered unexpected exception from watcher {} : ", (Object)watcher, (Object)t);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.warn("Encountered unexpected exception when firing watched event {} : ", (Object)event, (Object)t);
                }
            }
        };
        HashSet<Watcher> watchers = new HashSet<Watcher>();
        watchers.add(watcher);
        try {
            RetryPolicy opRetryPolicy = null == this.retryPolicy ? new BoundExponentialBackoffRetryPolicy(this.sessionTimeoutMs, this.sessionTimeoutMs, 0) : this.retryPolicy;
            BoundExponentialBackoffRetryPolicy connectRetryPolicy = null == this.retryPolicy ? new BoundExponentialBackoffRetryPolicy(this.sessionTimeoutMs, this.sessionTimeoutMs, 0) : new BoundExponentialBackoffRetryPolicy(this.sessionTimeoutMs, this.sessionTimeoutMs, Integer.MAX_VALUE);
            zk = org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.ZooKeeperClient.newBuilder().connectString(this.zooKeeperServers).sessionTimeoutMs(this.sessionTimeoutMs).watchers(watchers).operationRetryPolicy(opRetryPolicy).connectRetryPolicy(connectRetryPolicy).statsLogger(this.statsLogger).retryThreadCount(this.retryThreadCount).requestRateLimit(this.requestRateLimit).build();
        }
        catch (KeeperException e) {
            throw new ZooKeeperConnectionException("Problem connecting to servers: " + this.zooKeeperServers, e);
        }
        catch (IOException e) {
            throw new ZooKeeperConnectionException("Problem connecting to servers: " + this.zooKeeperServers, e);
        }
        return zk;
    }

    public Watcher registerExpirationHandler(final ZooKeeperSessionExpireNotifier onExpired) {
        Watcher watcher = new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.Expired) {
                    try {
                        onExpired.notifySessionExpired();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.register(watcher);
        return watcher;
    }

    public void register(Watcher watcher) {
        if (null != watcher) {
            this.watchers.add(watcher);
        }
    }

    public boolean unregister(Watcher watcher) {
        return null != watcher && this.watchers.remove(watcher);
    }

    public synchronized void closeInternal() {
        if (this.zooKeeper != null) {
            try {
                LOG.info("Closing zookeeper client {}.", (Object)this.name);
                this.zooKeeper.close();
                LOG.info("Closed zookeeper client {}.", (Object)this.name);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted trying to close zooKeeper {} : ", (Object)this.name, (Object)e);
            }
            finally {
                this.zooKeeper = null;
            }
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LOG.info("Close zookeeper client {}.", (Object)this.name);
        this.closeInternal();
        this.watcherManager.unregisterGauges();
        this.closed = true;
    }

    public static class ZooKeeperConnectionException
    extends IOException {
        private static final long serialVersionUID = 6682391687004819361L;

        public ZooKeeperConnectionException(String message) {
            super(message);
        }

        public ZooKeeperConnectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ZooKeeperSessionExpireNotifier {
        public void notifySessionExpired();
    }

    public static class DigestCredentials
    implements Credentials {
        String username;
        String password;

        public DigestCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void authenticate(ZooKeeper zooKeeper) {
            zooKeeper.addAuthInfo("digest", String.format("%s:%s", this.username, this.password).getBytes(StandardCharsets.UTF_8));
        }
    }

    public static interface Credentials {
        public static final Credentials NONE = new Credentials(){

            @Override
            public void authenticate(ZooKeeper zooKeeper) {
            }
        };

        public void authenticate(ZooKeeper var1);
    }
}

