/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogReadHandler;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ReadUtils;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.logsegment.LogSegmentFilter;
import org.apache.distributedlog.util.Utils;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReadUtils
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestReadUtils.class);
    @Rule
    public TestName runtime = new TestName();

    private CompletableFuture<Optional<LogRecordWithDLSN>> getLogRecordNotLessThanTxId(BKDistributedLogManager bkdlm, int logsegmentIdx, long transactionId) throws Exception {
        List<LogSegmentMetadata> logSegments = bkdlm.getLogSegments();
        return ReadUtils.getLogRecordNotLessThanTxId(bkdlm.getStreamName(), logSegments.get(logsegmentIdx), transactionId, Executors.newSingleThreadExecutor(), bkdlm.getReaderEntryStore(), 10);
    }

    private CompletableFuture<LogRecordWithDLSN> getFirstGreaterThanRecord(BKDistributedLogManager bkdlm, int ledgerNo, DLSN dlsn) throws Exception {
        List<LogSegmentMetadata> ledgerList = bkdlm.getLogSegments();
        return ReadUtils.asyncReadFirstUserRecord(bkdlm.getStreamName(), ledgerList.get(ledgerNo), 2, 16, new AtomicInteger(0), Executors.newFixedThreadPool(1), bkdlm.getReaderEntryStore(), dlsn);
    }

    private CompletableFuture<LogRecordWithDLSN> getLastUserRecord(BKDistributedLogManager bkdlm, int ledgerNo) throws Exception {
        BKLogReadHandler readHandler = bkdlm.createReadHandler();
        List<LogSegmentMetadata> ledgerList = Utils.ioResult(readHandler.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null)).getValue();
        return ReadUtils.asyncReadLastRecord(bkdlm.getStreamName(), ledgerList.get(ledgerNo), false, false, false, 2, 16, new AtomicInteger(0), Executors.newFixedThreadPool(1), bkdlm.getReaderEntryStore());
    }

    @Test(timeout=60000L)
    public void testForwardScanFirstRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(1L, 0L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals((String)"should be an exact match", (Object)dlsn, (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanNotFirstRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(1L, 1L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals((String)"should be an exact match", (Object)dlsn, (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanValidButNonExistentRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(1L, 0L, 1L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 1L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanForRecordAfterLedger() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(2L, 0L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals(null, (Object)logrec);
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanForRecordBeforeLedger() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        long txid = 1L;
        txid += DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, txid);
        txid += DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, txid);
        txid += DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, txid);
        DLSN dlsn = new DLSN(1L, 3L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 1, dlsn);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(2L, 0L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanControlRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 5, 5, 1L);
        DLSN dlsn = new DLSN(1L, 3L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 5L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLastRecordUserRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 5, 5, 1L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getLastUserRecord(bkdlm, 0);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 9L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLastRecordControlRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        BKAsyncLogWriter out = bkdlm.startAsyncLogSegmentNonPartitioned();
        int txid = 1;
        Utils.ioResult(out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult(out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult(out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult(out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, true)));
        Utils.ioResult(out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, true)));
        Utils.close(out);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getLastUserRecord(bkdlm, 0);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 2L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLastRecordAllControlRecords() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 5, 0, 1L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getLastUserRecord(bkdlm, 0);
        LogRecordWithDLSN logrec = Utils.ioResult(futureLogrec);
        Assert.assertEquals(null, (Object)logrec);
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetEntriesToSearch() throws Exception {
        Assert.assertTrue((boolean)ReadUtils.getEntriesToSearch(2L, 1L, 10).isEmpty());
        Assert.assertEquals(Lists.newArrayList(1L), ReadUtils.getEntriesToSearch(1L, 1L, 10));
        Assert.assertEquals(Lists.newArrayList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L), ReadUtils.getEntriesToSearch(1L, 10L, 10));
        Assert.assertEquals(Lists.newArrayList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L), ReadUtils.getEntriesToSearch(1L, 9L, 10));
        Assert.assertEquals(Lists.newArrayList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L), ReadUtils.getEntriesToSearch(1L, 8L, 10));
        Assert.assertEquals(Lists.newArrayList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 11L), ReadUtils.getEntriesToSearch(1L, 11L, 10));
        Assert.assertEquals(Lists.newArrayList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 12L), ReadUtils.getEntriesToSearch(1L, 12L, 10));
    }

    @Test(timeout=60000L)
    public void testGetEntriesToSearchByTxnId() throws Exception {
        LogRecordWithDLSN firstRecord = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 0L, 0L), 999L);
        LogRecordWithDLSN secondRecord = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 10L, 0L), 99L);
        LogRecordWithDLSN thirdRecord = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 100L, 0L), 1099L);
        Assert.assertTrue((boolean)ReadUtils.getEntriesToSearch(888L, firstRecord, secondRecord, 10).isEmpty());
        Assert.assertTrue((boolean)ReadUtils.getEntriesToSearch(888L, firstRecord, firstRecord, 10).isEmpty());
        Assert.assertEquals((long)2L, (long)ReadUtils.getEntriesToSearch(888L, firstRecord, thirdRecord, 2).size());
        Assert.assertEquals((long)3L, (long)ReadUtils.getEntriesToSearch(1099L, firstRecord, thirdRecord, 2).size());
        LogRecordWithDLSN record1 = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 0L, 0L), 88L);
        LogRecordWithDLSN record2 = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 12L, 0L), 888L);
        LogRecordWithDLSN record3 = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 12L, 0L), 999L);
        Assert.assertEquals(Lists.newArrayList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 10L, 11L), ReadUtils.getEntriesToSearch(888L, record1, record2, 10));
        Assert.assertEquals(Lists.newArrayList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 11L), ReadUtils.getEntriesToSearch(888L, record1, record3, 10));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdWithGreaterTxId() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 1, 1L);
        Optional<LogRecordWithDLSN> result = Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 999L));
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdWithLessTxId() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 1, 999L);
        Optional<LogRecordWithDLSN> result = Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 99L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)999L, (long)result.get().getTransactionId());
        Assert.assertEquals((long)0L, (long)result.get().getDlsn().getEntryId());
        Assert.assertEquals((long)0L, (long)result.get().getDlsn().getSlotId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdOnSmallSegment() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 5, 1L);
        Optional<LogRecordWithDLSN> result = Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 3L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)3L, (long)result.get().getTransactionId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdOnLargeSegment() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 100, 1L);
        Optional<LogRecordWithDLSN> result = Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 9L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)9L, (long)result.get().getTransactionId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordGreaterThanTxIdOnLargeSegment() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned(bkdlm, 0, 100, 1L, 3L);
        Optional<LogRecordWithDLSN> result = Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 23L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)25L, (long)result.get().getTransactionId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordGreaterThanTxIdOnSameTxId() throws Exception {
        LogRecord record;
        int i;
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        BKAsyncLogWriter out = bkdlm.startAsyncLogSegmentNonPartitioned();
        long txid = 1L;
        for (int i2 = 0; i2 < 10; ++i2) {
            LogRecord record2 = DLMTestUtil.getLargeLogRecordInstance(txid);
            Utils.ioResult(out.write(record2));
            ++txid;
        }
        long txidToSearch = txid;
        for (i = 0; i < 10; ++i) {
            record = DLMTestUtil.getLargeLogRecordInstance(txidToSearch);
            Utils.ioResult(out.write(record));
        }
        for (i = 0; i < 10; ++i) {
            record = DLMTestUtil.getLargeLogRecordInstance(txid);
            Utils.ioResult(out.write(record));
            ++txid;
        }
        Utils.close(out);
        Optional<LogRecordWithDLSN> result = Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, txidToSearch));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)10L, (long)result.get().getDlsn().getEntryId());
    }
}

