/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.exceptions.InvalidEnvelopedEntryException;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.exceptions.WriteException;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.io.CompressionUtils;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvelopedEntryWriter
implements Entry.Writer {
    private static final Logger logger = LoggerFactory.getLogger(EnvelopedEntryWriter.class);
    private final String logName;
    private final ByteBuf buffer;
    private ByteBuf finalizedBuffer = null;
    private final LogRecord.Writer writer;
    private final List<WriteRequest> writeRequests;
    private final boolean envelopeBeforeTransmit;
    private final CompressionCodec.Type codec;
    private final int flags;
    private int count = 0;
    private boolean hasUserData = false;
    private long maxTxId = Long.MIN_VALUE;

    EnvelopedEntryWriter(String logName, int initialBufferSize, boolean envelopeBeforeTransmit, CompressionCodec.Type codec) {
        this.logName = logName;
        this.buffer = PooledByteBufAllocator.DEFAULT.buffer(Math.min(Math.max(initialBufferSize * 6 / 5, 13), 1044480), 1044480);
        this.writer = new LogRecord.Writer(this.buffer);
        this.writeRequests = new LinkedList<WriteRequest>();
        this.envelopeBeforeTransmit = envelopeBeforeTransmit;
        this.codec = codec;
        this.flags = codec.code() & 3;
        if (envelopeBeforeTransmit) {
            this.buffer.writerIndex(13);
        }
    }

    @Override
    public synchronized void writeRecord(LogRecord record, CompletableFuture<DLSN> transmitPromise) throws LogRecordTooLongException, WriteException {
        int logRecordSize = record.getPersistentSize();
        if (logRecordSize > 1040384) {
            throw new LogRecordTooLongException("Log Record of size " + logRecordSize + " written when only " + 1040384 + " is allowed");
        }
        try {
            this.writer.writeOp(record);
            int numRecords = 1;
            if (!record.isControl()) {
                this.hasUserData = true;
            }
            if (record.isRecordSet()) {
                numRecords = LogRecordSet.numRecords(record);
            }
            this.count += numRecords;
            this.writeRequests.add(new WriteRequest(numRecords, transmitPromise));
            this.maxTxId = Math.max(this.maxTxId, record.getTransactionId());
        }
        catch (IOException e) {
            logger.error("Failed to append record to record set of {} : ", (Object)this.logName, (Object)e);
            throw new WriteException(this.logName, "Failed to append record to record set of " + this.logName);
        }
    }

    private synchronized void satisfyPromises(long lssn, long entryId) {
        long nextSlotId = 0L;
        for (WriteRequest request : this.writeRequests) {
            request.promise.complete(new DLSN(lssn, entryId, nextSlotId));
            nextSlotId += (long)request.numRecords;
        }
        this.writeRequests.clear();
    }

    private synchronized void cancelPromises(Throwable reason) {
        for (WriteRequest request : this.writeRequests) {
            request.promise.completeExceptionally(reason);
        }
        this.writeRequests.clear();
    }

    @Override
    public synchronized long getMaxTxId() {
        return this.maxTxId;
    }

    @Override
    public synchronized boolean hasUserRecords() {
        return this.hasUserData;
    }

    @Override
    public int getNumBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public synchronized int getNumRecords() {
        return this.count;
    }

    @Override
    public synchronized ByteBuf getBuffer() throws InvalidEnvelopedEntryException, IOException {
        if (null == this.finalizedBuffer) {
            this.finalizedBuffer = this.finalizeBuffer();
        }
        return this.finalizedBuffer.retainedSlice();
    }

    private ByteBuf finalizeBuffer() {
        if (!this.envelopeBeforeTransmit) {
            return this.buffer.retain();
        }
        int dataOffset = 13;
        int dataLen = this.buffer.readableBytes() - 13;
        if (CompressionCodec.Type.NONE == this.codec) {
            this.buffer.setByte(0, 1);
            this.buffer.setInt(1, this.flags);
            this.buffer.setInt(5, dataLen);
            this.buffer.setInt(9, dataLen);
            return this.buffer.retain();
        }
        CompressionCodec compressor = CompressionUtils.getCompressionCodec(this.codec);
        ByteBuf uncompressedBuf = this.buffer.slice(dataOffset, dataLen);
        ByteBuf compressedBuf = compressor.compress(uncompressedBuf, 13);
        compressedBuf.setByte(0, 1);
        compressedBuf.setInt(1, this.flags);
        compressedBuf.setInt(5, dataLen);
        compressedBuf.setInt(9, compressedBuf.readableBytes() - 13);
        return compressedBuf;
    }

    @Override
    public synchronized DLSN finalizeTransmit(long lssn, long entryId) {
        return new DLSN(lssn, entryId, this.count - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeTransmit(long lssn, long entryId) {
        this.satisfyPromises(lssn, entryId);
        this.buffer.release();
        EnvelopedEntryWriter envelopedEntryWriter = this;
        synchronized (envelopedEntryWriter) {
            ReferenceCountUtil.release(this.finalizedBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTransmit(Throwable reason) {
        this.cancelPromises(reason);
        this.buffer.release();
        EnvelopedEntryWriter envelopedEntryWriter = this;
        synchronized (envelopedEntryWriter) {
            ReferenceCountUtil.release(this.finalizedBuffer);
        }
    }

    private static class WriteRequest {
        private final int numRecords;
        private final CompletableFuture<DLSN> promise;

        WriteRequest(int numRecords, CompletableFuture<DLSN> promise) {
            this.numRecords = numRecords;
            this.promise = promise;
        }
    }
}

