/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356;

import java.net.URI;
import org.apache.pulsar.shade.org.eclipse.jetty.util.log.Log;
import org.apache.pulsar.shade.org.eclipse.jetty.util.log.Logger;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.LogicalConnection;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.SessionFactory;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.WebSocketSession;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.events.EventDriver;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;

public class JsrSessionFactory
implements SessionFactory {
    private static final Logger LOG = Log.getLogger(JsrSessionFactory.class);
    private final ClientContainer container;

    public JsrSessionFactory(ClientContainer container) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container: {}", container);
        }
        this.container = container;
    }

    @Override
    public WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        return new JsrSession(this.container, connection.getId(), requestURI, websocket, connection);
    }

    @Override
    public boolean supports(EventDriver websocket) {
        return websocket instanceof AbstractJsrEventDriver;
    }
}

