/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.controller;

import java.io.IOException;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ExitCode;
import org.apache.pulsar.shade.org.apache.zookeeper.server.controller.ControlCommand;
import org.apache.pulsar.shade.org.apache.zookeeper.server.controller.ControllerServerConfig;
import org.apache.pulsar.shade.org.apache.zookeeper.server.controller.ZooKeeperServerController;
import org.apache.pulsar.shade.org.apache.zookeeper.util.ServiceUtils;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Request;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Server;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandListener {
    private static final Logger LOG = LoggerFactory.getLogger(CommandListener.class);
    private ZooKeeperServerController controller;
    private Server server;

    public CommandListener(ZooKeeperServerController controller, ControllerServerConfig config) {
        try {
            this.controller = controller;
            String host = config.getControllerAddress().getHostName();
            int port = config.getControllerAddress().getPort();
            this.server = new Server(port);
            LOG.info("CommandListener server host: {} with port: {}", (Object)host, (Object)port);
            this.server.setHandler(new CommandHandler());
            this.server.start();
        }
        catch (Exception ex) {
            LOG.error("Failed to instantiate CommandListener.", (Throwable)ex);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    public void close() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception during shutdown CommandListener server", (Throwable)ex);
        }
    }

    private class CommandHandler
    extends AbstractHandler {
        private CommandHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            int responseCode;
            String commandStr = request.getPathInfo().substring(1);
            response.setContentType("text/html;charset=utf-8");
            try {
                ControlCommand command = ControlCommand.parseUri(commandStr);
                CommandListener.this.controller.processCommand(command);
                baseRequest.setHandled(true);
                responseCode = 200;
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Bad argument or command", (Throwable)ex);
                responseCode = 400;
            }
            catch (Exception ex) {
                LOG.error("Failed processing the request", (Throwable)ex);
                throw ex;
            }
            response.setStatus(responseCode);
            response.getWriter().println(commandStr);
            LOG.info("CommandListener processed command {} with response code {}", (Object)commandStr, (Object)responseCode);
        }
    }
}

