/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.proto;

import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperProtocol;

class RequestUtils {
    RequestUtils() {
    }

    public static boolean isFenceRequest(BookkeeperProtocol.ReadRequest readRequest) {
        return RequestUtils.hasFlag(readRequest, BookkeeperProtocol.ReadRequest.Flag.FENCE_LEDGER);
    }

    public static boolean isLongPollReadRequest(BookkeeperProtocol.ReadRequest readRequest) {
        return !RequestUtils.isFenceRequest(readRequest) && readRequest.hasPreviousLAC();
    }

    public static boolean isHighPriority(BookkeeperProtocol.Request request) {
        return request.getHeader().getPriority() > 0;
    }

    public static boolean shouldPiggybackEntry(BookkeeperProtocol.ReadRequest readRequest) {
        return RequestUtils.hasFlag(readRequest, BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK);
    }

    static boolean hasFlag(BookkeeperProtocol.ReadRequest request, BookkeeperProtocol.ReadRequest.Flag flag) {
        return request.hasFlag() && request.getFlag() == flag;
    }

    static boolean hasFlag(BookkeeperProtocol.AddRequest request, BookkeeperProtocol.AddRequest.Flag flag) {
        return request.hasFlag() && request.getFlag() == flag;
    }

    public static String toSafeString(BookkeeperProtocol.Request request) {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(request);
        BookkeeperProtocol.BKPacketHeader header = request.getHeader();
        if (request.hasAddRequest()) {
            BookkeeperProtocol.AddRequest addRequest = request.getAddRequest();
            RequestUtils.includeHeaderFields(stringHelper, header);
            stringHelper.add("ledgerId", addRequest.getLedgerId());
            stringHelper.add("entryId", addRequest.getEntryId());
            if (addRequest.hasFlag()) {
                stringHelper.add("flag", addRequest.getFlag());
            }
            if (addRequest.hasWriteFlags()) {
                stringHelper.add("writeFlags", addRequest.getWriteFlags());
            }
            return stringHelper.toString();
        }
        if (request.hasReadRequest()) {
            BookkeeperProtocol.ReadRequest readRequest = request.getReadRequest();
            RequestUtils.includeHeaderFields(stringHelper, header);
            stringHelper.add("ledgerId", readRequest.getLedgerId());
            stringHelper.add("entryId", readRequest.getEntryId());
            if (readRequest.hasFlag()) {
                stringHelper.add("flag", readRequest.getFlag());
            }
            if (readRequest.hasPreviousLAC()) {
                stringHelper.add("previousLAC", readRequest.getPreviousLAC());
            }
            if (readRequest.hasTimeOut()) {
                stringHelper.add("timeOut", readRequest.getTimeOut());
            }
            return stringHelper.toString();
        }
        if (request.hasWriteLacRequest()) {
            BookkeeperProtocol.WriteLacRequest writeLacRequest = request.getWriteLacRequest();
            RequestUtils.includeHeaderFields(stringHelper, header);
            stringHelper.add("ledgerId", writeLacRequest.getLedgerId());
            stringHelper.add("lac", writeLacRequest.getLac());
            return stringHelper.toString();
        }
        if (request.hasForceLedgerRequest()) {
            BookkeeperProtocol.ForceLedgerRequest forceLedgerRequest = request.getForceLedgerRequest();
            RequestUtils.includeHeaderFields(stringHelper, header);
            stringHelper.add("ledgerId", forceLedgerRequest.getLedgerId());
            return stringHelper.toString();
        }
        return request.toString();
    }

    private static void includeHeaderFields(MoreObjects.ToStringHelper stringHelper, BookkeeperProtocol.BKPacketHeader header) {
        stringHelper.add("version", header.getVersion());
        stringHelper.add("operation", header.getOperation());
        stringHelper.add("txnId", header.getTxnId());
        if (header.hasPriority()) {
            stringHelper.add("priority", header.getPriority());
        }
    }
}

