/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.google.common.graph;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.pulsar.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.shade.com.google.common.base.Function;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.graph.AbstractBaseGraph;
import org.apache.pulsar.shade.com.google.common.graph.AbstractGraph;
import org.apache.pulsar.shade.com.google.common.graph.ElementOrder;
import org.apache.pulsar.shade.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.apache.pulsar.shade.com.google.common.graph.EndpointPair;
import org.apache.pulsar.shade.com.google.common.graph.Graph;
import org.apache.pulsar.shade.com.google.common.graph.ValueGraph;

@ElementTypesAreNonnullByDefault
@Beta
public abstract class AbstractValueGraph<N, V>
extends AbstractBaseGraph<N>
implements ValueGraph<N, V> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractValueGraph.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                return AbstractValueGraph.this.edges();
            }

            @Override
            public boolean isDirected() {
                return AbstractValueGraph.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractValueGraph.this.allowsSelfLoops();
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractValueGraph.this.nodeOrder();
            }

            @Override
            public ElementOrder<N> incidentEdgeOrder() {
                return AbstractValueGraph.this.incidentEdgeOrder();
            }

            @Override
            public Set<N> adjacentNodes(N node) {
                return AbstractValueGraph.this.adjacentNodes(node);
            }

            @Override
            public Set<N> predecessors(N node) {
                return AbstractValueGraph.this.predecessors(node);
            }

            @Override
            public Set<N> successors(N node) {
                return AbstractValueGraph.this.successors(node);
            }

            @Override
            public int degree(N node) {
                return AbstractValueGraph.this.degree(node);
            }

            @Override
            public int inDegree(N node) {
                return AbstractValueGraph.this.inDegree(node);
            }

            @Override
            public int outDegree(N node) {
                return AbstractValueGraph.this.outDegree(node);
            }
        };
    }

    @Override
    public Optional<V> edgeValue(N nodeU, N nodeV) {
        return Optional.ofNullable(this.edgeValueOrDefault(nodeU, nodeV, null));
    }

    @Override
    public Optional<V> edgeValue(EndpointPair<N> endpoints) {
        return Optional.ofNullable(this.edgeValueOrDefault(endpoints, null));
    }

    @Override
    public final boolean equals(@CheckForNull Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueGraph)) {
            return false;
        }
        ValueGraph other = (ValueGraph)obj;
        return this.isDirected() == other.isDirected() && this.nodes().equals(other.nodes()) && AbstractValueGraph.edgeValueMap(this).equals(AbstractValueGraph.edgeValueMap(other));
    }

    @Override
    public final int hashCode() {
        return AbstractValueGraph.edgeValueMap(this).hashCode();
    }

    public String toString() {
        boolean bl = this.isDirected();
        boolean bl2 = this.allowsSelfLoops();
        String string = String.valueOf(this.nodes());
        String string2 = String.valueOf(AbstractValueGraph.edgeValueMap(this));
        return new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("isDirected: ").append(bl).append(", allowsSelfLoops: ").append(bl2).append(", nodes: ").append(string).append(", edges: ").append(string2).toString();
    }

    private static <N, V> Map<EndpointPair<N>, V> edgeValueMap(final ValueGraph<N, V> graph) {
        Function edgeToValueFn = new Function<EndpointPair<N>, V>(){

            @Override
            public V apply(EndpointPair<N> edge) {
                return Objects.requireNonNull(graph.edgeValueOrDefault(edge.nodeU(), edge.nodeV(), null));
            }
        };
        return Maps.asMap(graph.edges(), edgeToValueFn);
    }
}

