/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.core;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.BatchSource;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class BatchPushSource<T>
implements BatchSource<T> {
    private LinkedBlockingQueue<Record<T>> queue;
    private static final int DEFAULT_QUEUE_LENGTH = 1000;
    private final NullRecord nullRecord = new NullRecord();

    public BatchPushSource() {
        this.queue = new LinkedBlockingQueue(this.getQueueLength());
    }

    @Override
    public Record<T> readNext() throws Exception {
        Record<T> record = this.queue.take();
        if (record instanceof ErrorNotifierRecord) {
            throw ((ErrorNotifierRecord)record).getException();
        }
        if (record instanceof NullRecord) {
            return null;
        }
        return record;
    }

    public void consume(Record<T> record) {
        try {
            if (record != null) {
                this.queue.put(record);
            } else {
                this.queue.put(this.nullRecord);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getQueueLength() {
        return 1000;
    }

    public void notifyError(Exception ex) {
        this.consume(new ErrorNotifierRecord(ex));
    }

    private static class ErrorNotifierRecord
    implements Record {
        private Exception e;

        public ErrorNotifierRecord(Exception e) {
            this.e = e;
        }

        public Object getValue() {
            return null;
        }

        public Exception getException() {
            return this.e;
        }
    }

    private static class NullRecord
    implements Record {
        private NullRecord() {
        }

        public Object getValue() {
            return null;
        }
    }
}

