/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.functions.api.StateStore;
import org.apache.pulsar.functions.instance.state.BKStateStoreImpl;
import org.apache.pulsar.functions.instance.state.StateStoreProvider;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.shade.com.google.common.base.Stopwatch;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.StorageClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.Table;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.Backoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKStateStoreProviderImpl
implements StateStoreProvider {
    private static final Logger log = LoggerFactory.getLogger(BKStateStoreProviderImpl.class);
    private String stateStorageServiceUrl;
    private Map<String, StorageClient> clients;

    @Override
    public void init(Map<String, Object> config, Function.FunctionDetails functionDetails) throws Exception {
        this.stateStorageServiceUrl = (String)config.get("stateStorageServiceUrl");
        this.clients = new HashMap<String, StorageClient>();
    }

    private StorageClient getStorageClient(String tenant, String namespace) {
        String tableNs = FunctionCommon.getStateNamespace(tenant, namespace);
        StorageClient client = this.clients.get(tableNs);
        if (null != client) {
            return client;
        }
        StorageClientSettings settings = StorageClientSettings.newBuilder().serviceUri(this.stateStorageServiceUrl).enableServerSideRouting(true).clientName("function-" + tableNs).backoffPolicy(Backoff.Jitter.of(Backoff.Jitter.Type.EXPONENTIAL, 100L, 2000L, 60L)).build();
        StorageClient storageClient = StorageClientBuilder.newBuilder().withSettings(settings).withNamespace(tableNs).build();
        this.clients.put(tableNs, storageClient);
        return storageClient;
    }

    /*
     * Exception decompiling
     */
    private void createStateTable(String stateStorageServiceUrl, String tenant, String namespace, String name) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Table<ByteBuf, ByteBuf> openStateTable(String tenant, String namespace, String name) throws Exception {
        StorageClient client = this.getStorageClient(tenant, namespace);
        log.info("Opening state table for function {}/{}/{}", new Object[]{tenant, namespace, name});
        Stopwatch openSw = Stopwatch.createStarted();
        while (openSw.elapsed(TimeUnit.MINUTES) < 1L) {
            try {
                return FutureUtils.result(client.openTable(name), 1L, TimeUnit.MINUTES);
            }
            catch (InternalServerException ise) {
                log.warn("Encountered internal server on opening state table '{}/{}/{}',  re-attempt in 100 milliseconds : {}", new Object[]{tenant, namespace, name, ise.getMessage()});
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Failed to open state table for function " + tenant + "/" + namespace + "/" + name + " within timeout period", e);
            }
        }
        throw new IOException("Failed to open state table for function " + tenant + "/" + namespace + "/" + name);
    }

    @Override
    public <T extends StateStore> T getStateStore(String tenant, String namespace, String name) throws Exception {
        this.createStateTable(this.stateStorageServiceUrl, tenant, namespace, name);
        Table<ByteBuf, ByteBuf> table = this.openStateTable(tenant, namespace, name);
        return (T)new BKStateStoreImpl(tenant, namespace, name, table);
    }

    @Override
    public void close() {
        this.clients.forEach((name, client) -> client.closeAsync().exceptionally(cause -> {
            log.warn("Failed to close state storage client", cause);
            return null;
        }));
        this.clients.clear();
    }
}

