/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.Gauge;

class WebExecutorStats
implements AutoCloseable {
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private final Gauge maxThreads;
    private final Gauge minThreads;
    private final Gauge idleThreads;
    private final Gauge activeThreads;
    private final Gauge currentThreads;
    private final WebExecutorThreadPool executor;
    private static volatile WebExecutorStats instance;

    static synchronized WebExecutorStats getStats(WebExecutorThreadPool executor) {
        if (null == instance) {
            instance = new WebExecutorStats(executor);
        }
        return instance;
    }

    private WebExecutorStats(WebExecutorThreadPool executor) {
        this.executor = executor;
        this.maxThreads = (Gauge)((Collector)Gauge.build("pulsar_web_executor_max_threads", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return WebExecutorStats.this.executor.getMaxThreads();
            }
        }, new String[0])).register();
        this.minThreads = (Gauge)((Collector)Gauge.build("pulsar_web_executor_min_threads", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return WebExecutorStats.this.executor.getMinThreads();
            }
        }, new String[0])).register();
        this.idleThreads = (Gauge)((Collector)Gauge.build("pulsar_web_executor_idle_threads", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return WebExecutorStats.this.executor.getIdleThreads();
            }
        }, new String[0])).register();
        this.activeThreads = (Gauge)((Collector)Gauge.build("pulsar_web_executor_active_threads", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return WebExecutorStats.this.executor.getThreads() - WebExecutorStats.this.executor.getIdleThreads();
            }
        }, new String[0])).register();
        this.currentThreads = (Gauge)((Collector)Gauge.build("pulsar_web_executor_current_threads", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return WebExecutorStats.this.executor.getThreads();
            }
        }, new String[0])).register();
    }

    @Override
    public void close() throws Exception {
        if (CLOSED.compareAndSet(false, true)) {
            CollectorRegistry.defaultRegistry.unregister(this.activeThreads);
            CollectorRegistry.defaultRegistry.unregister(this.maxThreads);
            CollectorRegistry.defaultRegistry.unregister(this.minThreads);
            CollectorRegistry.defaultRegistry.unregister(this.idleThreads);
            CollectorRegistry.defaultRegistry.unregister(this.currentThreads);
        }
    }
}

